/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;

public final class JsonUtils {
    private static final Logger LOGGER = Logger.getLogger(JsonUtils.class.getCanonicalName());
    public static final String ABOUT = "@about";
    public static final String RESOURCE = "@resource";
    public static final String VALUE = "#value";
    public static ObjectMapper jsonMapper;

    private JsonUtils() {
        throw new AssertionError();
    }

    public static Object extractField(Object document, String jsonPath) {
        return JsonPath.read(document, jsonPath, new Predicate[0]);
    }

    public static List<String> extractList(Object value) {
        ArrayList<String> extracted = new ArrayList<String>();
        if (value.getClass() == String.class) {
            extracted.add((String)value);
        } else if (value.getClass() == JSONArray.class) {
            JSONArray array1 = (JSONArray)value;
            int l = array1.size();
            for (int i = 0; i < l; ++i) {
                if (array1.get(i).getClass() == JSONArray.class) {
                    JSONArray array2 = (JSONArray)array1.get(i);
                    int l2 = array2.size();
                    for (int j = 0; j < l2; ++j) {
                        if (array2.get(j).getClass() == String.class) {
                            extracted.add((String)array2.get(j));
                            continue;
                        }
                        if (array2.get(j).getClass() == LinkedHashMap.class) {
                            LinkedHashMap map = (LinkedHashMap)array2.get(j);
                            if (map.containsKey(ABOUT)) {
                                extracted.add((String)map.get(ABOUT));
                                continue;
                            }
                            if (map.containsKey(RESOURCE)) {
                                extracted.add((String)map.get(RESOURCE));
                                continue;
                            }
                            if (map.containsKey(VALUE)) {
                                extracted.add((String)map.get(VALUE));
                                continue;
                            }
                            LOGGER.severe("Other type of map*: " + map.keySet());
                            continue;
                        }
                        LOGGER.severe("Unhandled array2 type: " + JsonUtils.getType(array2.get(j)));
                    }
                    continue;
                }
                if (array1.get(i).getClass() == String.class) {
                    extracted.add((String)array1.get(i));
                    continue;
                }
                LOGGER.severe("Unhandled array1 type: " + JsonUtils.getType(array1.get(i)));
            }
        } else if (value.getClass() == LinkedHashMap.class) {
            for (Object innerValue : ((Map)value).values()) {
                extracted.addAll(JsonUtils.extractList(innerValue));
            }
        } else {
            LOGGER.severe("Unhandled object type: " + JsonUtils.getType(value));
        }
        return extracted;
    }

    public static List<? extends XmlFieldInstance> extractFieldInstanceList(Object value, String recordId, String jsonPath) {
        ArrayList<EdmFieldInstance> extracted = new ArrayList<EdmFieldInstance>();
        if (value.getClass() == String.class) {
            extracted.add(new EdmFieldInstance((String)value));
        } else if (value.getClass() == JSONArray.class) {
            JSONArray outerArray = (JSONArray)value;
            if (outerArray.isEmpty()) {
                return null;
            }
            int l = outerArray.size();
            for (int i = 0; i < l; ++i) {
                Object outerVal = outerArray.get(i);
                if (outerVal == null) continue;
                if (outerVal.getClass() == String.class) {
                    extracted.add(new EdmFieldInstance((String)outerVal));
                    continue;
                }
                if (outerVal.getClass() == Boolean.class) {
                    extracted.add(new EdmFieldInstance(Boolean.toString((Boolean)outerVal)));
                    continue;
                }
                if (outerVal.getClass() == Double.class) {
                    extracted.add(new EdmFieldInstance(Double.toString((Double)outerVal)));
                    continue;
                }
                if (outerVal.getClass() == Long.class) {
                    extracted.add(new EdmFieldInstance(Long.toString((Long)outerVal)));
                    continue;
                }
                if (outerVal.getClass() == BigDecimal.class) {
                    extracted.add(new EdmFieldInstance(((BigDecimal)outerVal).toString()));
                    continue;
                }
                if (outerVal.getClass() == BigInteger.class) {
                    extracted.add(new EdmFieldInstance(((BigInteger)outerVal).toString()));
                    continue;
                }
                if (outerVal.getClass() == JSONArray.class) {
                    extracted.addAll(JsonUtils.extractInnerArray(outerVal, recordId, jsonPath));
                    continue;
                }
                if (outerVal.getClass() == LinkedHashMap.class) {
                    extracted.add(JsonUtils.hashToFieldInstance(outerVal, recordId, jsonPath));
                    continue;
                }
                LOGGER.severe(String.format("Unhandled outerArray type: %s, %s [record ID: %s, path: %s]", JsonUtils.getType(outerVal), outerVal, recordId, jsonPath));
            }
        } else if (value.getClass() == LinkedHashMap.class) {
            extracted.add(JsonUtils.hashToFieldInstance(value, recordId, jsonPath));
        } else if (value.getClass() == Integer.class) {
            extracted.add(new EdmFieldInstance(Integer.toString((Integer)value)));
        } else if (value.getClass() == Float.class) {
            extracted.add(new EdmFieldInstance(Float.toString(((Float)value).floatValue())));
        } else if (value.getClass() == Double.class) {
            extracted.add(new EdmFieldInstance(Double.toString((Double)value)));
        } else if (value.getClass() == Boolean.class) {
            extracted.add(new EdmFieldInstance(Boolean.toString((Boolean)value)));
        } else if (value.getClass() == BigDecimal.class) {
            extracted.add(new EdmFieldInstance(((BigDecimal)value).toString()));
        } else if (value.getClass() == BigInteger.class) {
            extracted.add(new EdmFieldInstance(((BigInteger)value).toString()));
        } else {
            LOGGER.severe(String.format("Unhandled object type: %s, [record ID: %s, path: %s]", JsonUtils.getType(value), recordId, jsonPath));
        }
        return extracted;
    }

    private static List<EdmFieldInstance> extractInnerArray(Object outerVal, String recordId, String jsonPath) {
        ArrayList<EdmFieldInstance> extracted = new ArrayList<EdmFieldInstance>();
        JSONArray array = (JSONArray)outerVal;
        int l2 = array.size();
        for (int j = 0; j < l2; ++j) {
            Object innerVal = array.get(j);
            if (innerVal.getClass() == String.class) {
                extracted.add(new EdmFieldInstance((String)innerVal));
                continue;
            }
            if (innerVal.getClass() == LinkedHashMap.class) {
                extracted.add(JsonUtils.hashToFieldInstance(innerVal, recordId, jsonPath));
                continue;
            }
            if (innerVal.getClass() == JSONArray.class) {
                extracted.addAll(JsonUtils.extractInnerArray(innerVal, recordId, jsonPath));
                continue;
            }
            LOGGER.severe(String.format("Unhandled inner array type: %s, [record ID: %s, path: %s]", JsonUtils.getType(array.get(j)), recordId, jsonPath));
        }
        return extracted;
    }

    public static EdmFieldInstance hashToFieldInstance(Object innerVal, String recordId, String jsonPath) {
        LinkedHashMap map = (LinkedHashMap)innerVal;
        EdmFieldInstance instance = new EdmFieldInstance();
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (((String)entry.getKey()).equals(ABOUT)) {
                instance.setResource((String)value);
                continue;
            }
            if (((String)entry.getKey()).equals(RESOURCE)) {
                instance.setResource((String)value);
                continue;
            }
            if (((String)entry.getKey()).equals(VALUE)) {
                instance.setValue((String)value);
                continue;
            }
            if (((String)entry.getKey()).equals("def")) {
                if (value instanceof JSONArray) {
                    JSONArray values2 = (JSONArray)value;
                    if (values2.size() > 1) {
                        LOGGER.severe(String.format("Multiple values in a 'def' value: %s, [record ID: %s, path: %s]", values2, recordId, jsonPath));
                        continue;
                    }
                    instance.setValue(values2.get(0).toString());
                    continue;
                }
                if (value instanceof String) {
                    instance.setValue(value.toString());
                    continue;
                }
                LOGGER.severe(String.format("Unhandled type in a 'def' value: %s, [record ID: %s, path: %s]", value, recordId, jsonPath));
                continue;
            }
            if (((String)entry.getKey()).equals("@lang")) {
                instance.setLanguage((String)value);
                continue;
            }
            LOGGER.severe(String.format("Other type (%s) of map: %s, [record ID: %s, path: %s]", entry.getKey(), map, recordId, jsonPath));
        }
        return instance;
    }

    public static String extractString(Object value) {
        String extracted = null;
        if (value.getClass() == String.class) {
            extracted = (String)value;
        } else if (value.getClass() == LinkedHashMap.class) {
            LinkedHashMap map = (LinkedHashMap)value;
            extracted = JsonUtils.extractString(map.values().toArray()[0]);
        } else if (value.getClass() == JSONArray.class) {
            extracted = ((JSONArray)value).get(0).toString();
        } else {
            LOGGER.severe("Unhandled object type: " + JsonUtils.getType(value));
        }
        return extracted;
    }

    public static String getType(Object obj) {
        return obj.getClass().getCanonicalName();
    }

    public static String toJson(Object object) throws JsonProcessingException {
        if (jsonMapper == null) {
            jsonMapper = new ObjectMapper();
        }
        return jsonMapper.writeValueAsString(object);
    }
}

