/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.io.reader;

import de.gwdg.metadataqa.api.calculator.CalculatorFacade;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.io.reader.RecordReader;
import de.gwdg.metadataqa.api.xml.XpathEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLRecordReader
extends RecordReader {
    private NodeList nodeList;
    private NamedNodeMap rootAttributes;
    private int current = 0;
    private Document xmlDocument;
    private CalculatorFacade calculator;

    public XMLRecordReader(BufferedReader inputReader, CalculatorFacade calculator) throws IOException {
        super(inputReader, calculator);
        this.calculator = calculator;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(inputReader);
            this.xmlDocument = builder.parse(inputSource);
            this.rootAttributes = this.xmlDocument.getDocumentElement().getAttributes();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public XMLRecordReader setRecordAddress(String xpathExpression) {
        XPath xPath = XpathEngineFactory.initializeEngine(this.calculator.getSchema().getNamespaces());
        try {
            XPathExpression expr = xPath.compile(xpathExpression);
            this.nodeList = (NodeList)expr.evaluate(this.xmlDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public String nodeToString(Node node) {
        this.injectNamespaces(node);
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            System.out.println("nodeToString Transformer Exception");
        }
        return sw.toString().replaceAll("\n\\s+\n", "\n");
    }

    private void injectNamespaces(Node node) {
        Element el = (Element)node;
        for (int i = 0; i < this.rootAttributes.getLength(); ++i) {
            Attr attr = (Attr)this.rootAttributes.item(i);
            el.setAttribute(attr.getName(), attr.getValue());
        }
    }

    public int getLength() {
        return this.nodeList.getLength();
    }

    @Override
    public boolean hasNext() {
        return this.current < this.nodeList.getLength();
    }

    @Override
    public Map<String, List<MetricResult>> next() {
        String record = this.nodeToString(this.nodeList.item(this.current++));
        return this.calculator.measureAsMetricResult(record);
    }
}

