/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.counter;

import de.gwdg.metadataqa.api.util.CompressionLevel;
import de.gwdg.metadataqa.api.util.Converter;
import de.gwdg.metadataqa.api.util.FileUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldCounter<T>
implements Serializable {
    private static final long serialVersionUID = -2422037365837281017L;
    private final Map<String, T> fieldMap = new LinkedHashMap<String, T>();

    public boolean has(String key) {
        return this.fieldMap.containsKey(key);
    }

    public T get(String key) {
        return this.fieldMap.get(key);
    }

    public void put(String key, T value) {
        this.fieldMap.put(key, value);
    }

    public void remove(String key) {
        this.fieldMap.remove(key);
    }

    public void putAll(Map<String, T> map) {
        this.fieldMap.putAll(map);
    }

    public int size() {
        return this.fieldMap.size();
    }

    public void putAll(FieldCounter<T> other) {
        this.fieldMap.putAll(other.getMap());
    }

    public Map<String, T> getMap() {
        return this.fieldMap;
    }

    public String getCsv(boolean withLabel) {
        return this.getCsv(withLabel, CompressionLevel.ZERO);
    }

    public String getCsv(boolean withLabel, CompressionLevel compressionLevel) {
        List<String> items = this.getList(withLabel, compressionLevel);
        return StringUtils.join(items, ',');
    }

    public List<String> getList(boolean withLabel, CompressionLevel compressionLevel) {
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<String, T> entry : this.fieldMap.entrySet()) {
            StringBuilder item = new StringBuilder();
            if (withLabel) {
                item.append(String.format("\"%s\":", entry.getKey()));
            }
            String value = Converter.asString(entry.getValue());
            if (!(entry.getValue() instanceof Integer) && compressionLevel != CompressionLevel.ZERO) {
                value = Converter.compressNumber(value, compressionLevel);
            }
            item.append(FileUtils.escape(value));
            items.add(item.toString());
        }
        return items;
    }

    public List<Object> getCsv() {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (T value : this.fieldMap.values()) {
            values2.add(value);
        }
        return values2;
    }

    public String toString() {
        return "FieldCounter{fieldMap=" + this.fieldMap + "}";
    }
}

