/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gwdg.metadataqa.api.configuration.MeasurementConfiguration;
import de.gwdg.metadataqa.api.configuration.SchemaConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class ConfigurationReader {
    private ConfigurationReader() {
    }

    public static SchemaConfiguration readSchemaJson(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readJson(fileName, SchemaConfiguration.class);
    }

    public static MeasurementConfiguration readMeasurementJson(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readJson(fileName, MeasurementConfiguration.class);
    }

    public static SchemaConfiguration readSchemaYaml(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readYaml(fileName, SchemaConfiguration.class);
    }

    public static MeasurementConfiguration readMeasurementYaml(String fileName) throws FileNotFoundException {
        return ConfigurationReader.readYaml(fileName, MeasurementConfiguration.class);
    }

    private static <T> T readJson(String fileName, Class<T> clazz) throws FileNotFoundException {
        T config;
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(fileName);
        try {
            config = objectMapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        return config;
    }

    private static <T> T readYaml(String fileName, Class<T> clazz) throws FileNotFoundException {
        Yaml yaml = new Yaml(new Constructor(clazz, new LoaderOptions()));
        FileInputStream inputStream2 = new FileInputStream(new File(fileName));
        return yaml.load(inputStream2);
    }
}

