/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator.language;

import de.gwdg.metadataqa.api.calculator.MultilingualitySaturationCalculator;
import de.gwdg.metadataqa.api.calculator.SkippedEntryChecker;
import de.gwdg.metadataqa.api.counter.BasicCounter;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.EdmFieldInstance;
import de.gwdg.metadataqa.api.model.LanguageSaturationType;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.Converter;
import de.gwdg.metadataqa.api.util.SkippedEntitySelector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Multilinguality {
    private static final String NA = "n.a.";
    public static final double NORMALIZED_LOW = 0.0;
    public static final double NORMALIZED_MIDDLE = 0.3;
    public static final double NORMALIZED_HIGH = 0.6;
    public static final int MIDDLE_FROM = 4;
    public static final int MIDDLE_TO = 9;
    public static final int LOW_FROM = 2;
    public static final int LOW_TO = 3;
    public static final double TRANSLATION_MODIFIER = -0.2;
    public static final String SUM = "multilingualitySaturation:sum";
    public static final String AVERAGE = "multilingualitySaturation:average";
    public static final String NORMALIZED = "multilingualitySaturation:normalized";
    private Schema schema;
    private Selector cache;
    private MultilingualitySaturationCalculator.ResultTypes resultType;
    private SkippedEntryChecker skippedEntryChecker;
    private SkippedEntitySelector skippedEntitySelector;
    Map<String, List<SortedMap<LanguageSaturationType, Double>>> rawLanguageMap = new LinkedHashMap<String, List<SortedMap<LanguageSaturationType, Double>>>();
    Map<String, Map<String, Double>> rawScoreMap = new LinkedHashMap<String, Map<String, Double>>();

    public Multilinguality(Schema schema, Selector cache2, MultilingualitySaturationCalculator.ResultTypes resultType, SkippedEntryChecker skippedEntryChecker, SkippedEntitySelector skippedEntitySelector) {
        this.schema = schema;
        this.cache = cache2;
        this.resultType = resultType;
        this.skippedEntryChecker = skippedEntryChecker;
        this.skippedEntitySelector = skippedEntitySelector;
    }

    public FieldCounter<Double> measure() {
        if (this.schema.getCollectionPaths().isEmpty()) {
            this.measureFlatSchema();
        } else {
            this.measureHierarchicalSchema();
        }
        FieldCounter<Double> saturationMap = this.calculateScore();
        Map<String, Map<String, Object>> mergedMap = this.mergeMaps(this.rawLanguageMap, this.rawScoreMap);
        return saturationMap;
    }

    private List<String> getSkippableIds() {
        return this.skippedEntryChecker != null ? this.skippedEntryChecker.getSkippableCollectionIds(this.cache) : new ArrayList<String>();
    }

    private void measureFlatSchema() {
        for (DataElement dataElement : this.schema.getPaths()) {
            if (!dataElement.isActive() || this.schema.getNoLanguageFields().contains(dataElement.getLabel())) continue;
            this.extractLanguageTags(null, dataElement, dataElement.getPath());
        }
    }

    private void measureHierarchicalSchema() {
        List<String> skippableIds = this.getSkippableIds();
        for (DataElement collection : this.schema.getCollectionPaths()) {
            if (!collection.isActive()) continue;
            Object rawJsonFragment = this.cache.getFragment(collection.getPath());
            if (rawJsonFragment == null) {
                this.measureMissingCollection(collection);
                continue;
            }
            this.measureExistingCollection(rawJsonFragment, collection, skippableIds);
        }
    }

    private void measureMissingCollection(DataElement collection) {
        for (DataElement child : collection.getChildren()) {
            if (!child.isActive() || this.schema.getNoLanguageFields().contains(child.getLabel())) continue;
            TreeMap<LanguageSaturationType, BasicCounter> languages = new TreeMap<LanguageSaturationType, BasicCounter>();
            this.increase(languages, LanguageSaturationType.NA);
            this.updateMaps(child.getLabel(), this.transformLanguages(languages, 0));
        }
    }

    private void measureExistingCollection(Object rawJsonFragment, DataElement collection, List<String> skippableIds) {
        List<Object> jsonFragments = Converter.jsonObjectToList(rawJsonFragment, this.schema);
        if (jsonFragments.isEmpty()) {
            this.measureMissingCollection(collection);
        } else {
            int len = jsonFragments.size();
            for (int i = 0; i < len; ++i) {
                Object jsonFragment = jsonFragments.get(i);
                boolean skip = this.skippedEntitySelector.isCollectionSkippable(skippableIds, collection, i, this.cache, jsonFragment);
                if (skip) {
                    this.measureMissingCollection(collection);
                    continue;
                }
                for (DataElement child : collection.getChildren()) {
                    if (!child.isActive() || this.schema.getNoLanguageFields().contains(child.getLabel())) continue;
                    String address = String.format("%s/%d/%s", collection.getPath(), i, child.getPath());
                    this.extractLanguageTags(jsonFragment, child, address);
                }
            }
        }
    }

    private void extractLanguageTags(Object jsonFragment, DataElement dataElement, String address) {
        List values2 = this.cache.get(address, dataElement.getPath(), jsonFragment);
        TreeMap<LanguageSaturationType, BasicCounter> languages = new TreeMap<LanguageSaturationType, BasicCounter>();
        HashSet<String> individualLanguages = new HashSet<String>();
        if (values2 != null && !values2.isEmpty()) {
            for (EdmFieldInstance field : values2) {
                if (field.hasValue()) {
                    if (field.hasLanguage()) {
                        individualLanguages.add(field.getLanguage());
                        this.increase(languages, LanguageSaturationType.LANGUAGE);
                        continue;
                    }
                    this.increase(languages, LanguageSaturationType.STRING);
                    continue;
                }
                this.increase(languages, LanguageSaturationType.LINK);
            }
        } else {
            this.increase(languages, LanguageSaturationType.NA);
        }
        this.updateMaps(dataElement.getLabel(), this.transformLanguages(languages, individualLanguages.size()));
    }

    private void updateMaps(String label, SortedMap<LanguageSaturationType, Double> instance) {
        this.rawLanguageMap.computeIfAbsent(label, s -> new ArrayList());
        this.rawLanguageMap.get(label).add(instance);
    }

    private void increase(Map<LanguageSaturationType, BasicCounter> languages, LanguageSaturationType key) {
        if (!languages.containsKey((Object)key)) {
            languages.put(key, new BasicCounter(1.0));
        } else {
            languages.get((Object)key).increaseTotal();
        }
    }

    private SortedMap<LanguageSaturationType, Double> transformLanguages(Map<LanguageSaturationType, BasicCounter> languages, int languageCount) {
        SortedMap<LanguageSaturationType, Double> result2 = new TreeMap<LanguageSaturationType, Double>();
        for (Map.Entry<LanguageSaturationType, BasicCounter> lang : languages.entrySet()) {
            result2.put(lang.getKey(), lang.getValue().getTotal());
        }
        if (result2.containsKey((Object)LanguageSaturationType.LANGUAGE) && (Double)result2.get((Object)LanguageSaturationType.LANGUAGE) > 1.0 && languageCount > 1) {
            result2.remove((Object)LanguageSaturationType.LANGUAGE);
            result2.put(LanguageSaturationType.TRANSLATION, this.normalizeTranslationCount(languageCount));
        }
        if (languageCount > 1) {
            result2 = this.keepOnlyTheBest(result2);
        }
        return result2;
    }

    private double normalizeTranslationCount(double count) {
        double normalized = 0.0;
        normalized = this.isLow(count) ? 0.0 : (this.isMiddle(count) ? 0.3 : 0.6);
        return normalized;
    }

    private boolean isMiddle(double count) {
        return 4.0 <= count && count <= 9.0;
    }

    private boolean isLow(double count) {
        return 2.0 <= count && count <= 3.0;
    }

    private Map<String, Map<String, Object>> mergeMaps(Map<String, List<SortedMap<LanguageSaturationType, Double>>> rawLanguageMap, Map<String, Map<String, Double>> rawScoreMap) {
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<String, List<SortedMap<LanguageSaturationType, Double>>> rawEntry : rawLanguageMap.entrySet()) {
            LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
            entry.put("instances", this.normalizeRawValue(rawEntry.getValue()));
            entry.put("score", rawScoreMap.get(rawEntry.getKey()));
            map.put(rawEntry.getKey(), entry);
        }
        return map;
    }

    private SortedMap<LanguageSaturationType, Double> keepOnlyTheBest(SortedMap<LanguageSaturationType, Double> result2) {
        if (result2.size() > 1) {
            LanguageSaturationType best = LanguageSaturationType.NA;
            for (LanguageSaturationType key : result2.keySet()) {
                if (!(key.value() > best.value())) continue;
                best = key;
            }
            if (best != LanguageSaturationType.NA) {
                double modifier = 0.0;
                if (best == LanguageSaturationType.TRANSLATION && result2.containsKey((Object)LanguageSaturationType.STRING)) {
                    modifier = -0.2;
                }
                TreeMap<LanguageSaturationType, Double> replacement = new TreeMap<LanguageSaturationType, Double>();
                replacement.put(best, (Double)result2.get((Object)best) + modifier);
                result2 = replacement;
            }
        }
        return result2;
    }

    private FieldCounter<Double> calculateScore() {
        double normalized;
        double average;
        double sum;
        ArrayList<Double> sums = new ArrayList<Double>();
        FieldCounter<Double> languageMap = new FieldCounter<Double>();
        for (Map.Entry<String, List<SortedMap<LanguageSaturationType, Double>>> field : this.rawLanguageMap.entrySet()) {
            LinkedHashMap<String, Double> fieldMap = new LinkedHashMap<String, Double>();
            List<SortedMap<LanguageSaturationType, Double>> values2 = field.getValue();
            sum = 0.0;
            boolean isSet = false;
            for (SortedMap<LanguageSaturationType, Double> value : values2) {
                double saturation = value.firstKey().value();
                if (saturation == -1.0) continue;
                double weight = (Double)value.get((Object)value.firstKey());
                if (value.firstKey() == LanguageSaturationType.TRANSLATION) {
                    saturation += weight;
                }
                sum += saturation;
                isSet = true;
            }
            if (!isSet) {
                average = LanguageSaturationType.NA.value();
                normalized = LanguageSaturationType.NA.value();
                sum = LanguageSaturationType.NA.value();
            } else {
                average = sum / (double)values2.size();
                normalized = Multilinguality.normalize(average);
                sums.add(sum);
            }
            fieldMap.put("sum", sum);
            fieldMap.put("average", average);
            fieldMap.put("normalized", normalized);
            this.rawScoreMap.put(field.getKey(), fieldMap);
            if (this.resultType.equals((Object)MultilingualitySaturationCalculator.ResultTypes.NORMAL)) {
                languageMap.put(field.getKey(), normalized);
                continue;
            }
            languageMap.put(field.getKey() + ":sum", sum);
            languageMap.put(field.getKey() + ":average", average);
            languageMap.put(field.getKey() + ":normalized", normalized);
        }
        sum = this.summarize(sums);
        average = sum / (double)sums.size();
        normalized = Multilinguality.normalize(average);
        if (this.resultType.equals((Object)MultilingualitySaturationCalculator.ResultTypes.EXTENDED)) {
            languageMap.put(SUM, sum);
            languageMap.put(AVERAGE, average);
        }
        languageMap.put(NORMALIZED, normalized);
        return languageMap;
    }

    private double summarize(List<Double> sums) {
        double sum = 0.0;
        for (Double item : sums) {
            sum += item.doubleValue();
        }
        return sum;
    }

    private static double normalize(double average) {
        return 1.0 - 1.0 / (average + 1.0);
    }

    private Object normalizeRawValue(List<SortedMap<LanguageSaturationType, Double>> values2) {
        ArrayList normalized = new ArrayList();
        for (SortedMap<LanguageSaturationType, Double> value : values2) {
            TreeMap<LanguageSaturationType, Double> norm = new TreeMap<LanguageSaturationType, Double>();
            double saturation = value.firstKey().value();
            double weight = (Double)value.get((Object)value.firstKey());
            if (value.firstKey() == LanguageSaturationType.TRANSLATION) {
                saturation += weight;
            }
            norm.put(value.firstKey(), saturation);
            normalized.add(norm);
        }
        return normalized;
    }
}

