/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import de.gwdg.metadataqa.api.calculator.solr.QaSolrClient;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.UniquenessField;
import de.gwdg.metadataqa.api.uniqueness.UniquenessFieldCalculator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UniquenessCalculator
extends QaSolrClient
implements Calculator,
Serializable {
    public static final String CALCULATOR_NAME = "uniqueness";
    private FieldCounter<Double> resultMap;

    public UniquenessCalculator(SolrClient solrClient, Schema schema) {
        super(solrClient, schema);
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public List<MetricResult> measure(Selector cache2) {
        String recordId = cache2.getRecordId();
        if (StringUtils.isNotBlank(recordId) && recordId.startsWith("/")) {
            recordId = recordId.substring(1);
        }
        this.resultMap = new FieldCounter();
        for (UniquenessField solrField : this.solrFields) {
            UniquenessFieldCalculator fieldCalculator = new UniquenessFieldCalculator(cache2, recordId, this.solrClient, solrField);
            fieldCalculator.calculate();
            this.resultMap.put(solrField.getSolrField() + "/count", fieldCalculator.getAverageCount());
            this.resultMap.put(solrField.getSolrField() + "/score", fieldCalculator.getAverageScore());
        }
        return List.of(new FieldCounterBasedResult<Double>(this.getCalculatorName(), this.resultMap));
    }

    public String getTotals() {
        ArrayList<Integer> totals = new ArrayList<Integer>();
        for (UniquenessField field : this.solrFields) {
            totals.add(field.getTotal());
        }
        return StringUtils.join(totals, ",");
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (UniquenessField field : this.solrFields) {
            headers.add(field.getSolrField() + "/count");
            headers.add(field.getSolrField() + "/score");
        }
        return headers;
    }

    public List<UniquenessField> getSolrFields() {
        return this.solrFields;
    }
}

