/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.SolrConfiguration;
import de.gwdg.metadataqa.api.uniqueness.TfIdf;
import de.gwdg.metadataqa.api.uniqueness.TfIdfExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.io.IOUtils;

public class TfIdfCalculator
implements Calculator,
Serializable {
    public static final String CALCULATOR_NAME = "uniqueness";
    private static final int MEGABYTE = 0x100000;
    private static final Logger LOGGER = Logger.getLogger(TfIdfCalculator.class.getCanonicalName());
    private static final String SOLR_SEARCH_PARAMS = "tvrh/?q=id:\"%s\"&version=2.2&indent=on&qt=tvrh&tv=true&tv.all=true&f.includes.tv.tf=true&tv.fl=dc_title_txt,dc_description_txt,dcterms_alternative_txt&wt=json&json.nl=map&rows=1000&fl=id";
    private static final HttpClient HTTP_CLIENT = new HttpClient();
    private SolrConfiguration solrConfiguration;
    private String solrSearchPath;
    private Map<String, List<TfIdf>> termsCollection;
    private boolean termCollectionEnabled = false;
    private Schema schema;
    private SolrClient solrClient;

    public TfIdfCalculator() {
    }

    public TfIdfCalculator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public List<MetricResult> measure(Selector cache2) {
        String recordId = cache2.getRecordId();
        if (recordId.startsWith("/")) {
            recordId = recordId.substring(1);
        }
        String solrJsonResponse = this.solrClient != null ? this.solrClient.getTfIdfResponse(String.format(SOLR_SEARCH_PARAMS, recordId).replace("\"", "%22"), recordId) : this.getSolrResponse(recordId);
        TfIdfExtractor extractor = new TfIdfExtractor(this.schema);
        FieldCounter<Double> resultMap = extractor.extract(solrJsonResponse, recordId, this.termCollectionEnabled);
        this.termsCollection = extractor.getTermsCollection();
        return List.of(new FieldCounterBasedResult<Double>(this.getCalculatorName(), resultMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSolrResponse(String recordId) {
        String jsonString = null;
        String url = String.format(this.getSolrSearchPath(), recordId).replace("\"", "%22");
        GetMethod method = new GetMethod(url);
        HttpMethodParams params = new HttpMethodParams();
        params.setIntParameter("http.method.response.buffer.warnlimit", 0x100000);
        method.setParams(params);
        try {
            int statusCode = HTTP_CLIENT.executeMethod(method);
            if (statusCode != 200) {
                LOGGER.severe("Method failed: " + method.getStatusLine());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy(method.getResponseBodyAsStream(), (OutputStream)baos);
            jsonString = baos.toString(StandardCharsets.UTF_8);
        }
        catch (HttpException e) {
            LOGGER.severe("Fatal protocol violation: " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.severe("Fatal transport error: " + e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return jsonString;
    }

    public Map<String, List<TfIdf>> getTermsCollection() {
        return this.termsCollection;
    }

    public void enableTermCollection(boolean enableTermCollection) {
        this.termCollectionEnabled = enableTermCollection;
    }

    public boolean isTermCollectionEnabled() {
        return this.termCollectionEnabled;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (DataElement dataElement : this.schema.getIndexFields()) {
            headers.add(dataElement.getLabel() + ":sum");
            headers.add(dataElement.getLabel() + ":avg");
        }
        return headers;
    }

    public void setSolrConfiguration(SolrConfiguration pSolrConfiguration) {
        this.solrConfiguration = pSolrConfiguration;
    }

    public String getSolrSearchPath() {
        if (this.solrSearchPath == null) {
            this.solrSearchPath = String.format("http://%s:%s/%s/%s", this.solrConfiguration.getSolrHost(), this.solrConfiguration.getSolrPort(), this.solrConfiguration.getSolrPath(), SOLR_SEARCH_PARAMS);
        }
        return this.solrSearchPath;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }
}

