/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.BaseLanguageCalculator;
import de.gwdg.metadataqa.api.calculator.language.Language;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.Schema;
import java.util.ArrayList;
import java.util.List;

public class LanguageCalculator
extends BaseLanguageCalculator {
    public static final String CALCULATOR_NAME = "languages";
    private Schema schema;

    public LanguageCalculator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        for (DataElement dataElement : this.schema.getPaths()) {
            if (!dataElement.isActive() || this.schema.getNoLanguageFields().contains(dataElement.getLabel())) continue;
            headers.add("lang:" + dataElement.getLabel());
        }
        return headers;
    }

    @Override
    public List<MetricResult> measure(Selector cache2) throws InvalidJsonException {
        Language language = new Language(this.schema, cache2);
        FieldCounter<String> languageMap = language.measure();
        return List.of(new FieldCounterBasedResult<String>(this.getCalculatorName(), languageMap).withNoCompression());
    }
}

