/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import de.gwdg.metadataqa.api.calculator.solr.QaSolrClient;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.interfaces.Shutdownable;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.SolrClient;
import de.gwdg.metadataqa.api.uniqueness.UniquenessField;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrServerException;

public class Indexer
extends QaSolrClient
implements Calculator,
Shutdownable,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(Indexer.class.getCanonicalName());
    public static final String CALCULATOR_NAME = "indexer";

    public Indexer(SolrClient solrClient, Schema schema) {
        super(solrClient, schema);
        solrClient.deleteAll();
    }

    @Override
    public List<MetricResult> measure(Selector cache2) {
        try {
            String recordId = this.extractValue(cache2, this.schema.getRecordId().getPath()).get(0);
            HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
            for (UniquenessField solrField : this.solrFields) {
                List<String> values2 = this.extractValue(cache2, solrField.getPath());
                if (values2.isEmpty()) continue;
                resultMap.put(solrField.getSolrField(), values2);
            }
            this.solrClient.indexMap(recordId, resultMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SolrServerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<String> extractValue(Selector cache2, String path) {
        ArrayList<String> values2 = new ArrayList<String>();
        List instances = cache2.get(path);
        if (instances != null && !instances.isEmpty()) {
            for (XmlFieldInstance instance : instances) {
                if (!instance.hasValue()) continue;
                values2.add(instance.getValue());
            }
        }
        return values2;
    }

    @Override
    public List<String> getHeader() {
        return new ArrayList<String>();
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public void shutDown() {
        LOGGER.info("shutDown");
        this.solrClient.commit();
    }
}

