/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.SkippedEntryChecker;
import de.gwdg.metadataqa.api.counter.CompletenessCounter;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.json.DataElement;
import de.gwdg.metadataqa.api.json.FieldGroup;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.problemcatalog.FieldCounterBasedResult;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import de.gwdg.metadataqa.api.util.Converter;
import de.gwdg.metadataqa.api.util.SkippedEntitySelector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class CompletenessCalculator<T extends XmlFieldInstance>
implements Calculator,
Serializable {
    public static final String CALCULATOR_NAME = "completeness";
    private String inputFileName;
    private CompletenessCounter completenessCounter;
    private FieldCounter<Boolean> existenceCounter;
    private FieldCounter<Integer> cardinalityCounter;
    private List<String> missingFields;
    private List<String> emptyFields;
    private List<String> existingFields;
    private Schema schema;
    private boolean collectFields = false;
    private boolean completeness = true;
    private boolean existence = true;
    private boolean cardinality = true;
    private SkippedEntryChecker skippedEntryChecker = null;
    private SkippedEntitySelector skippedEntitySelector = new SkippedEntitySelector();

    public CompletenessCalculator() {
    }

    public CompletenessCalculator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    @Override
    public List<MetricResult> measure(Selector cache2) throws InvalidJsonException {
        ArrayList<String> skippableIds;
        this.initializeCounters();
        List<Object> list = skippableIds = this.skippedEntryChecker != null ? this.skippedEntryChecker.getSkippableCollectionIds(cache2) : new ArrayList();
        if (this.schema.getCollectionPaths() == null || this.schema.getCollectionPaths().isEmpty()) {
            for (DataElement dataElement : this.schema.getPaths()) {
                if (!dataElement.isActive()) continue;
                this.evaluateDataElement(dataElement, cache2, this.completenessCounter, dataElement.getLabel(), null);
            }
        } else {
            for (DataElement collection : this.schema.getCollectionPaths()) {
                if (!collection.isActive()) continue;
                Object rawJsonFragment = cache2.getFragment(collection.getPath());
                List<Object> jsonFragments = Converter.jsonObjectToList(rawJsonFragment, this.schema);
                if (jsonFragments.isEmpty()) {
                    this.handleEmptyFragment(collection);
                    continue;
                }
                int len = jsonFragments.size();
                for (int i = 0; i < len; ++i) {
                    Object jsonFragment = jsonFragments.get(i);
                    if (this.skippedEntitySelector.isCollectionSkippable(skippableIds, collection, i, cache2, jsonFragment)) {
                        this.handleEmptyFragment(collection);
                        continue;
                    }
                    for (DataElement child : collection.getChildren()) {
                        if (!child.isActive()) continue;
                        String address = String.format("%s/%d/%s", collection.getPath(), i, child.getPath());
                        this.evaluateDataElement(child, cache2, this.completenessCounter, address, jsonFragment);
                    }
                }
            }
        }
        if (this.schema.getFieldGroups() != null) {
            for (FieldGroup fieldGroup : this.schema.getFieldGroups()) {
                boolean existing = false;
                for (String field : fieldGroup.getFields()) {
                    if (!Boolean.TRUE.equals(this.existenceCounter.get(field))) continue;
                    existing = true;
                    break;
                }
                this.completenessCounter.increaseInstance(fieldGroup.getCategory(), existing);
            }
        }
        ArrayList<MetricResult> list2 = new ArrayList<MetricResult>();
        list2.add(new FieldCounterBasedResult<Double>(CALCULATOR_NAME, this.completenessCounter.getFieldCounter()));
        list2.add(new FieldCounterBasedResult<Boolean>("existence", this.existenceCounter));
        list2.add(new FieldCounterBasedResult<Integer>("cardinality", this.cardinalityCounter));
        if (this.collectFields) {
            // empty if block
        }
        return list2;
    }

    public void initializeCounters() {
        this.completenessCounter = new CompletenessCounter(this.schema);
        this.existenceCounter = new FieldCounter();
        this.cardinalityCounter = new FieldCounter();
        if (this.collectFields) {
            this.missingFields = new ArrayList<String>();
            this.emptyFields = new ArrayList<String>();
            this.existingFields = new ArrayList<String>();
        }
    }

    public void handleEmptyFragment(DataElement collection) {
        for (DataElement child : collection.getChildren()) {
            if (!child.isActive()) continue;
            this.handleValues(this.completenessCounter, child, null);
        }
    }

    public void evaluateDataElement(DataElement dataElement, Selector cache2, CompletenessCounter completenessCounter, String address, Object jsonFragment) {
        List values2 = cache2.get(address, dataElement.getPath(), jsonFragment);
        this.handleValues(completenessCounter, dataElement, values2);
    }

    private void handleValues(CompletenessCounter completenessCounter, DataElement dataElement, List<T> values2) {
        if (this.completeness) {
            completenessCounter.increaseTotal(dataElement.getCategories());
        }
        if (values2 != null && !values2.isEmpty() && !this.isEmpty(values2)) {
            this.handleNonNullValues(completenessCounter, dataElement, values2);
        } else {
            this.handleNullValues(dataElement);
        }
    }

    private boolean isEmpty(List<T> values2) {
        boolean empty2 = true;
        for (XmlFieldInstance value : values2) {
            if (value.isEmpty()) continue;
            empty2 = false;
            break;
        }
        return empty2;
    }

    private void handleNonNullValues(CompletenessCounter completenessCounter, DataElement dataElement, List<T> values2) {
        String label = dataElement.getLabel();
        if (this.completeness) {
            completenessCounter.increaseInstance(dataElement.getCategories());
        }
        if (this.existence) {
            this.existenceCounter.put(label, true);
        }
        if (this.cardinality) {
            if (!this.cardinalityCounter.has(label)) {
                this.cardinalityCounter.put(label, values2.size());
            } else {
                this.cardinalityCounter.put(label, values2.size() + this.cardinalityCounter.get(label));
            }
        }
        if (this.collectFields) {
            this.existingFields.add(label);
        }
    }

    private void handleNullValues(DataElement dataElement) {
        if (this.existence && !this.existenceCounter.has(dataElement.getLabel())) {
            this.existenceCounter.put(dataElement.getLabel(), false);
        }
        if (this.cardinality && !this.cardinalityCounter.has(dataElement.getLabel())) {
            this.cardinalityCounter.put(dataElement.getLabel(), 0);
        }
        if (this.collectFields && !this.missingFields.contains(dataElement.getLabel())) {
            this.missingFields.add(dataElement.getLabel());
        }
    }

    public void collectFields(boolean collectFields) {
        this.collectFields = collectFields;
    }

    public List<String> getMissingFields() {
        return this.missingFields;
    }

    public List<String> getEmptyFields() {
        return this.emptyFields;
    }

    public List<String> getExistingFields() {
        return this.existingFields;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public Map<String, ? extends Object> getResultMap() {
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>();
        if (this.completeness) {
            resultMap.putAll(this.completenessCounter.getFieldCounter().getMap());
        }
        if (this.existence) {
            for (Map.Entry<String, Comparable<Boolean>> entry : this.existenceCounter.getMap().entrySet()) {
                resultMap.put("existence:" + entry.getKey(), BooleanUtils.toInteger((Boolean)entry.getValue()));
            }
        }
        if (this.cardinality) {
            for (Map.Entry<String, Comparable<Boolean>> entry : this.cardinalityCounter.getMap().entrySet()) {
                resultMap.put("cardinality:" + entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }

    public Map<String, Map<String, ? extends Object>> getLabelledResultMap() {
        LinkedHashMap<String, Map<String, ? extends Object>> resultMap = new LinkedHashMap<String, Map<String, ? extends Object>>();
        if (this.completeness) {
            resultMap.put(CALCULATOR_NAME, this.completenessCounter.getFieldCounter().getMap());
        }
        if (this.existence) {
            resultMap.put("existence", this.existenceCounter.getMap());
        }
        if (this.cardinality) {
            resultMap.put("cardinality", this.cardinalityCounter.getMap());
        }
        return resultMap;
    }

    public String getCsv(boolean withLabel, CompressionLevel compressionLevel) {
        List<String> csvs = this.getList(withLabel, compressionLevel);
        return StringUtils.join(csvs, ",");
    }

    public List<Object> getCsv() {
        ArrayList<Object> csvs = new ArrayList<Object>();
        if (this.completeness) {
            csvs.addAll(this.completenessCounter.getFieldCounter().getCsv());
        }
        if (this.existence) {
            csvs.addAll(this.existenceCounter.getCsv().stream().map(v -> BooleanUtils.toInteger((Boolean)v)).collect(Collectors.toList()));
        }
        if (this.cardinality) {
            csvs.addAll(this.cardinalityCounter.getCsv());
        }
        return csvs;
    }

    public List<String> getList(boolean withLabel, CompressionLevel compressionLevel) {
        ArrayList<String> csvs = new ArrayList<String>();
        if (this.completeness) {
            csvs.addAll(this.completenessCounter.getFieldCounter().getList(withLabel, compressionLevel));
        }
        if (this.existence) {
            csvs.addAll(this.existenceCounter.getList(withLabel, compressionLevel));
        }
        if (this.cardinality) {
            csvs.addAll(this.cardinalityCounter.getList(withLabel, compressionLevel));
        }
        return csvs;
    }

    @Override
    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        if (this.completeness) {
            for (String name : CompletenessCounter.getHeaders(this.schema)) {
                headers.add("completeness:" + name);
            }
        }
        if (this.existence) {
            for (DataElement dataElement : this.schema.getPaths()) {
                if (dataElement.isCollection() || !dataElement.isActive()) continue;
                headers.add("existence:" + dataElement.getLabel());
            }
        }
        if (this.cardinality) {
            for (DataElement dataElement : this.schema.getPaths()) {
                if (dataElement.isCollection() || !dataElement.isActive()) continue;
                headers.add("cardinality:" + dataElement.getLabel());
            }
        }
        return headers;
    }

    public Map<String, Boolean> getExistenceMap() {
        return this.existenceCounter.getMap();
    }

    public Map<String, Integer> getCardinalityMap() {
        return this.cardinalityCounter.getMap();
    }

    public CompletenessCounter getCompletenessCounter() {
        return this.completenessCounter;
    }

    public FieldCounter<Boolean> getExistenceCounter() {
        return this.existenceCounter;
    }

    public FieldCounter<Integer> getCardinalityCounter() {
        return this.cardinalityCounter;
    }

    public boolean isCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(boolean completeness) {
        this.completeness = completeness;
    }

    public boolean isExistence() {
        return this.existence;
    }

    public void setExistence(boolean existence) {
        this.existence = existence;
    }

    public boolean isCardinality() {
        return this.cardinality;
    }

    public void setCardinality(boolean cardinality) {
        this.cardinality = cardinality;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SkippedEntryChecker getSkippedEntryChecker() {
        return this.skippedEntryChecker;
    }

    public void setSkippedEntryChecker(SkippedEntryChecker skippedEntryChecker) {
        this.skippedEntryChecker = skippedEntryChecker;
        this.skippedEntitySelector.setSkippedEntryChecker(skippedEntryChecker);
    }
}

