/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.calculator;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.CalculatorFactory;
import de.gwdg.metadataqa.api.calculator.CompletenessCalculator;
import de.gwdg.metadataqa.api.calculator.TfIdfCalculator;
import de.gwdg.metadataqa.api.calculator.output.MetricCollector;
import de.gwdg.metadataqa.api.calculator.output.OutputCollector;
import de.gwdg.metadataqa.api.configuration.MeasurementConfiguration;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.interfaces.MetricResult;
import de.gwdg.metadataqa.api.interfaces.Shutdownable;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.selector.CsvSelector;
import de.gwdg.metadataqa.api.model.selector.Selector;
import de.gwdg.metadataqa.api.model.selector.SelectorFactory;
import de.gwdg.metadataqa.api.schema.Format;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.uniqueness.TfIdf;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import de.gwdg.metadataqa.api.util.CsvReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalculatorFacade
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(CalculatorFacade.class.getCanonicalName());
    private static final long serialVersionUID = -5956665711362465908L;
    protected MeasurementConfiguration configuration;
    protected boolean isFirstRecord = true;
    protected CompressionLevel compressionLevel = CompressionLevel.NORMAL;
    private boolean changed = false;
    protected List<Calculator> calculators = new ArrayList<Calculator>();
    protected CompletenessCalculator completenessCalculator;
    protected TfIdfCalculator tfidfCalculator;
    protected Selector<? extends XmlFieldInstance> cache;
    protected Schema schema;
    protected CsvReader csvReader;

    public CalculatorFacade() {
        this.configuration = new MeasurementConfiguration();
    }

    public CalculatorFacade(MeasurementConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void conditionalConfiguration() {
        if (this.changed) {
            this.configure();
            this.changed = false;
        }
    }

    public void configure() {
        LOGGER.info("configure()");
        this.calculators = CalculatorFactory.create(this.configuration, this.schema);
    }

    public String measure(String inputRecord) throws InvalidJsonException {
        return (String)this.measureWithGenerics(inputRecord);
    }

    public String measure(List<String> inputRecord) throws InvalidJsonException {
        return (String)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.STRING);
    }

    public List<String> measureAsList(String inputRecord) throws InvalidJsonException {
        return (List)this.measureWithGenerics(inputRecord, OutputCollector.TYPE.STRING_LIST);
    }

    public List<String> measureAsList(List<String> inputRecord) throws InvalidJsonException {
        return (List)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.STRING_LIST);
    }

    public List<Object> measureAsListOfObjects(String inputRecord) throws InvalidJsonException {
        return (List)this.measureWithGenerics(inputRecord, OutputCollector.TYPE.OBJECT_LIST);
    }

    public List<Object> measureAsListOfObjects(List<String> inputRecord) throws InvalidJsonException {
        return (List)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.OBJECT_LIST);
    }

    public Map<String, Object> measureAsMap(String inputRecord) throws InvalidJsonException {
        return (Map)this.measureWithGenerics(inputRecord, OutputCollector.TYPE.MAP);
    }

    public Map<String, Object> measureAsMap(List<String> inputRecord) throws InvalidJsonException {
        return (Map)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.MAP);
    }

    public String measureAsJson(String inputRecord) throws InvalidJsonException {
        return (String)this.measureWithGenerics(inputRecord, OutputCollector.TYPE.JSON);
    }

    public String measureAsJson(List<String> inputRecord) throws InvalidJsonException {
        return (String)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.JSON);
    }

    public Map<String, List<MetricResult>> measureAsMetricResult(String inputRecord) throws InvalidJsonException {
        return (Map)this.measureWithGenerics(inputRecord, OutputCollector.TYPE.METRIC);
    }

    public Map<String, List<MetricResult>> measureAsMetricResult(List<String> inputRecord) throws InvalidJsonException {
        return (Map)this.measureCsvWithGenerics(inputRecord, OutputCollector.TYPE.METRIC);
    }

    protected <T extends XmlFieldInstance> Object measureWithGenerics(String content) throws InvalidJsonException {
        return this.measureWithGenerics(content, OutputCollector.TYPE.STRING);
    }

    protected <T extends XmlFieldInstance> Object measureWithGenerics(String content, OutputCollector.TYPE type2) throws InvalidJsonException {
        this.conditionalConfiguration();
        MetricCollector collector = new MetricCollector();
        if (this.schema == null) {
            throw new IllegalStateException("schema is missing");
        }
        Format format = this.schema.getFormat();
        if (format != null && content != null) {
            this.cache = SelectorFactory.getInstance(this.schema.getFormat(), content);
            if (this.schema.getFormat().equals((Object)Format.CSV)) {
                this.initializeCsvCache(content);
            }
            if (!(this.isFirstRecord && this.schema.getFormat().equals((Object)Format.CSV) && this.csvReader.isHeaderAware())) {
                this.runMeasurements(collector);
            }
            this.isFirstRecord = false;
        }
        return collector.createOutput(type2, this.compressionLevel);
    }

    private void initializeCsvCache(String content) {
        if (this.isFirstRecord && this.csvReader.isHeaderAware()) {
            try {
                this.csvReader.setHeader(content);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "initializeCsvCache", e);
            }
        }
        ((CsvSelector)this.cache).setCsvReader(this.csvReader);
    }

    protected <T extends XmlFieldInstance> Object measureCsvWithGenerics(List<String> content, OutputCollector.TYPE type2) throws InvalidJsonException {
        if (this.schema == null) {
            throw new IllegalStateException("schema is missing");
        }
        Format format = this.schema.getFormat();
        if (format == null || format != Format.CSV) {
            throw new IllegalStateException("Format is not CSV");
        }
        this.conditionalConfiguration();
        MetricCollector collector = new MetricCollector();
        if (content != null) {
            this.cache = new CsvSelector(this.csvReader, content);
            this.runMeasurements(collector);
        }
        return collector.createOutput(type2, this.compressionLevel);
    }

    private void runMeasurements(OutputCollector collector) {
        if (this.calculators != null) {
            for (Calculator calculator : this.getCalculators()) {
                List<MetricResult> result2 = calculator.measure(this.cache);
                collector.addResult(calculator, result2, this.compressionLevel);
            }
        }
    }

    public List<Calculator> getCalculators() {
        return this.calculators;
    }

    public List<String> getExistingFields() {
        return this.completenessCalculator.getExistingFields();
    }

    public List<String> getEmptyFields() {
        return this.completenessCalculator.getEmptyFields();
    }

    public List<String> getMissingFields() {
        return this.completenessCalculator.getMissingFields();
    }

    public Map<String, List<TfIdf>> getTermsCollection() {
        return this.tfidfCalculator.getTermsCollection();
    }

    public List<String> getHeader() {
        this.conditionalConfiguration();
        ArrayList<String> header = new ArrayList<String>();
        if (this.calculators != null) {
            for (Calculator calculator : this.getCalculators()) {
                header.addAll(calculator.getHeader());
            }
        }
        return header;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public CalculatorFacade setCompressionLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.changed = true;
        return this;
    }

    public Selector<? extends XmlFieldInstance> getCache() {
        return this.cache;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public CalculatorFacade setSchema(Schema schema) {
        this.schema = schema;
        this.changed = true;
        return this;
    }

    public CalculatorFacade setCsvReader() {
        return this.setCsvReader(false);
    }

    public CalculatorFacade setCsvReader(boolean headerAware) {
        this.csvReader = new CsvReader().setHeaderAware(headerAware);
        this.changed = true;
        return this;
    }

    public CalculatorFacade setCsvReader(CsvReader csvReader) {
        this.csvReader = csvReader;
        this.changed = true;
        return this;
    }

    public void shutDown() {
        for (Calculator calculator : this.getCalculators()) {
            if (!(calculator instanceof Shutdownable)) continue;
            ((Shutdownable)((Object)calculator)).shutDown();
        }
    }
}

