/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.api.abbreviation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AbbreviationManager
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(AbbreviationManager.class.getCanonicalName());
    private static final long serialVersionUID = 8680703008286808252L;
    private Map<String, Integer> data = new LinkedHashMap<String, Integer>();
    private static FileSystem fs;
    private String fileName;

    protected void initialize(String pFileName) {
        this.initialize(pFileName, false);
    }

    protected void initialize(String pFileName, boolean parse) {
        this.fileName = pFileName;
        Path path = null;
        try {
            path = AbbreviationManager.getPath(pFileName);
            List<String> lines = Files.readAllLines(path, Charset.defaultCharset());
            int i = 1;
            for (String line : lines) {
                this.processLine(line, i, parse);
            }
        }
        catch (IOException | URISyntaxException | FileSystemNotFoundException ex) {
            LOGGER.severe(String.format("Error with file: %s, path: %s.", pFileName, path));
            LOGGER.severe(ex.getLocalizedMessage());
        }
    }

    public void processLine(String line, int i, boolean parse) throws NumberFormatException {
        if (parse && line.contains(";")) {
            String[] parts = line.split(";", 2);
            this.data.put(parts[1].replace("\\n", "\n"), Integer.parseInt(parts[0]));
        } else {
            this.data.put(line, i++);
        }
    }

    public Integer lookup(String entry) {
        if (!this.data.containsKey(entry)) {
            int oldsize = this.data.size();
            this.data.put(entry, this.data.size() + 1);
            Object msg = String.format("new entry: %s (size: %d -> %d)", entry, oldsize, this.data.size());
            if (this.fileName != null) {
                msg = (String)msg + " " + this.fileName;
            }
            LOGGER.info((String)msg);
        }
        return this.data.get(entry);
    }

    public void save(String fileName) throws FileNotFoundException, UnsupportedEncodingException {
        try (PrintWriter writer = new PrintWriter(fileName, "UTF-8");){
            for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
                writer.println(String.format("%d;%s", entry.getValue(), entry.getKey()));
            }
            writer.flush();
        }
    }

    public String searchById(Integer id) {
        if (this.data.containsValue(id)) {
            for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
                if (!entry.getValue().equals(id)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private static Path getPath(String fileName) throws IOException, URISyntaxException {
        Path path;
        URL url = AbbreviationManager.class.getClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException(String.format("File %s is not existing", fileName));
        }
        URI uri = url.toURI();
        HashMap env = new HashMap();
        if (uri.toString().contains("!")) {
            String[] parts = uri.toString().split("!", 2);
            if (fs == null) {
                fs = FileSystems.newFileSystem(URI.create(parts[0]), env);
            }
            path = fs.getPath(parts[1], new String[0]);
        } else {
            path = Paths.get(uri);
        }
        return path;
    }

    public Map<String, Integer> getData() {
        return this.data;
    }

    public Integer getOrDefault(String key, Integer defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }
}

