/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.moshi.internal.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class StandardJsonAdapters {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        public JsonAdapter<?> create(Type type2, Set<? extends Annotation> annotations2, Moshi moshi) {
            if (!annotations2.isEmpty()) {
                return null;
            }
            if (type2 == Boolean.TYPE) {
                return BOOLEAN_JSON_ADAPTER;
            }
            if (type2 == Byte.TYPE) {
                return BYTE_JSON_ADAPTER;
            }
            if (type2 == Character.TYPE) {
                return CHARACTER_JSON_ADAPTER;
            }
            if (type2 == Double.TYPE) {
                return DOUBLE_JSON_ADAPTER;
            }
            if (type2 == Float.TYPE) {
                return FLOAT_JSON_ADAPTER;
            }
            if (type2 == Integer.TYPE) {
                return INTEGER_JSON_ADAPTER;
            }
            if (type2 == Long.TYPE) {
                return LONG_JSON_ADAPTER;
            }
            if (type2 == Short.TYPE) {
                return SHORT_JSON_ADAPTER;
            }
            if (type2 == Boolean.class) {
                return BOOLEAN_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Byte.class) {
                return BYTE_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Character.class) {
                return CHARACTER_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Double.class) {
                return DOUBLE_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Float.class) {
                return FLOAT_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Integer.class) {
                return INTEGER_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Long.class) {
                return LONG_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Short.class) {
                return SHORT_JSON_ADAPTER.nullSafe();
            }
            if (type2 == String.class) {
                return STRING_JSON_ADAPTER.nullSafe();
            }
            if (type2 == Object.class) {
                return new ObjectJsonAdapter(moshi).nullSafe();
            }
            Class<?> rawType = Types.getRawType(type2);
            JsonAdapter<?> generatedAdapter = Util.generatedAdapter(moshi, type2, rawType);
            if (generatedAdapter != null) {
                return generatedAdapter;
            }
            if (rawType.isEnum()) {
                return new EnumJsonAdapter(rawType).nullSafe();
            }
            return null;
        }
    };
    private static final String ERROR_FORMAT = "Expected %s but was %s at path %s";
    static final JsonAdapter<Boolean> BOOLEAN_JSON_ADAPTER = new JsonAdapter<Boolean>(){

        @Override
        public Boolean fromJson(JsonReader reader) throws IOException {
            return reader.nextBoolean();
        }

        @Override
        public void toJson(JsonWriter writer, Boolean value) throws IOException {
            writer.value((boolean)value);
        }

        public String toString() {
            return "JsonAdapter(Boolean)";
        }
    };
    static final JsonAdapter<Byte> BYTE_JSON_ADAPTER = new JsonAdapter<Byte>(){

        @Override
        public Byte fromJson(JsonReader reader) throws IOException {
            return (byte)StandardJsonAdapters.rangeCheckNextInt(reader, "a byte", -128, 255);
        }

        @Override
        public void toJson(JsonWriter writer, Byte value) throws IOException {
            writer.value(value.intValue() & 0xFF);
        }

        public String toString() {
            return "JsonAdapter(Byte)";
        }
    };
    static final JsonAdapter<Character> CHARACTER_JSON_ADAPTER = new JsonAdapter<Character>(){

        @Override
        public Character fromJson(JsonReader reader) throws IOException {
            String value = reader.nextString();
            if (value.length() > 1) {
                throw new JsonDataException(String.format(StandardJsonAdapters.ERROR_FORMAT, "a char", '\"' + value + '\"', reader.getPath()));
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public void toJson(JsonWriter writer, Character value) throws IOException {
            writer.value(value.toString());
        }

        public String toString() {
            return "JsonAdapter(Character)";
        }
    };
    static final JsonAdapter<Double> DOUBLE_JSON_ADAPTER = new JsonAdapter<Double>(){

        @Override
        public Double fromJson(JsonReader reader) throws IOException {
            return reader.nextDouble();
        }

        @Override
        public void toJson(JsonWriter writer, Double value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Double)";
        }
    };
    static final JsonAdapter<Float> FLOAT_JSON_ADAPTER = new JsonAdapter<Float>(){

        @Override
        public Float fromJson(JsonReader reader) throws IOException {
            float value = (float)reader.nextDouble();
            if (!reader.isLenient() && Float.isInfinite(value)) {
                throw new JsonDataException("JSON forbids NaN and infinities: " + value + " at path " + reader.getPath());
            }
            return Float.valueOf(value);
        }

        @Override
        public void toJson(JsonWriter writer, Float value) throws IOException {
            if (value == null) {
                throw new NullPointerException();
            }
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Float)";
        }
    };
    static final JsonAdapter<Integer> INTEGER_JSON_ADAPTER = new JsonAdapter<Integer>(){

        @Override
        public Integer fromJson(JsonReader reader) throws IOException {
            return reader.nextInt();
        }

        @Override
        public void toJson(JsonWriter writer, Integer value) throws IOException {
            writer.value(value.intValue());
        }

        public String toString() {
            return "JsonAdapter(Integer)";
        }
    };
    static final JsonAdapter<Long> LONG_JSON_ADAPTER = new JsonAdapter<Long>(){

        @Override
        public Long fromJson(JsonReader reader) throws IOException {
            return reader.nextLong();
        }

        @Override
        public void toJson(JsonWriter writer, Long value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(Long)";
        }
    };
    static final JsonAdapter<Short> SHORT_JSON_ADAPTER = new JsonAdapter<Short>(){

        @Override
        public Short fromJson(JsonReader reader) throws IOException {
            return (short)StandardJsonAdapters.rangeCheckNextInt(reader, "a short", Short.MIN_VALUE, Short.MAX_VALUE);
        }

        @Override
        public void toJson(JsonWriter writer, Short value) throws IOException {
            writer.value(value.intValue());
        }

        public String toString() {
            return "JsonAdapter(Short)";
        }
    };
    static final JsonAdapter<String> STRING_JSON_ADAPTER = new JsonAdapter<String>(){

        @Override
        public String fromJson(JsonReader reader) throws IOException {
            return reader.nextString();
        }

        @Override
        public void toJson(JsonWriter writer, String value) throws IOException {
            writer.value(value);
        }

        public String toString() {
            return "JsonAdapter(String)";
        }
    };

    private StandardJsonAdapters() {
    }

    static int rangeCheckNextInt(JsonReader reader, String typeMessage, int min, int max) throws IOException {
        int value = reader.nextInt();
        if (value < min || value > max) {
            throw new JsonDataException(String.format(ERROR_FORMAT, typeMessage, value, reader.getPath()));
        }
        return value;
    }

    static final class ObjectJsonAdapter
    extends JsonAdapter<Object> {
        private final Moshi moshi;
        private final JsonAdapter<List> listJsonAdapter;
        private final JsonAdapter<Map> mapAdapter;
        private final JsonAdapter<String> stringAdapter;
        private final JsonAdapter<Double> doubleAdapter;
        private final JsonAdapter<Boolean> booleanAdapter;

        ObjectJsonAdapter(Moshi moshi) {
            this.moshi = moshi;
            this.listJsonAdapter = moshi.adapter(List.class);
            this.mapAdapter = moshi.adapter(Map.class);
            this.stringAdapter = moshi.adapter(String.class);
            this.doubleAdapter = moshi.adapter(Double.class);
            this.booleanAdapter = moshi.adapter(Boolean.class);
        }

        @Override
        public Object fromJson(JsonReader reader) throws IOException {
            switch (reader.peek()) {
                case BEGIN_ARRAY: {
                    return this.listJsonAdapter.fromJson(reader);
                }
                case BEGIN_OBJECT: {
                    return this.mapAdapter.fromJson(reader);
                }
                case STRING: {
                    return this.stringAdapter.fromJson(reader);
                }
                case NUMBER: {
                    return this.doubleAdapter.fromJson(reader);
                }
                case BOOLEAN: {
                    return this.booleanAdapter.fromJson(reader);
                }
                case NULL: {
                    return reader.nextNull();
                }
            }
            throw new IllegalStateException("Expected a value but was " + (Object)((Object)reader.peek()) + " at path " + reader.getPath());
        }

        @Override
        public void toJson(JsonWriter writer, Object value) throws IOException {
            Class<?> valueClass = value.getClass();
            if (valueClass == Object.class) {
                writer.beginObject();
                writer.endObject();
            } else {
                this.moshi.adapter(this.toJsonType(valueClass), Util.NO_ANNOTATIONS).toJson(writer, value);
            }
        }

        private Class<?> toJsonType(Class<?> valueClass) {
            if (Map.class.isAssignableFrom(valueClass)) {
                return Map.class;
            }
            if (Collection.class.isAssignableFrom(valueClass)) {
                return Collection.class;
            }
            return valueClass;
        }

        public String toString() {
            return "JsonAdapter(Object)";
        }
    }

    static final class EnumJsonAdapter<T extends Enum<T>>
    extends JsonAdapter<T> {
        private final Class<T> enumType;
        private final String[] nameStrings;
        private final T[] constants;
        private final JsonReader.Options options;

        EnumJsonAdapter(Class<T> enumType) {
            this.enumType = enumType;
            try {
                this.constants = (Enum[])enumType.getEnumConstants();
                this.nameStrings = new String[this.constants.length];
                for (int i = 0; i < this.constants.length; ++i) {
                    T constant = this.constants[i];
                    String constantName = ((Enum)constant).name();
                    this.nameStrings[i] = Util.jsonName(constantName, enumType.getField(constantName));
                }
                this.options = JsonReader.Options.of(this.nameStrings);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError("Missing field in " + enumType.getName(), e);
            }
        }

        @Override
        public T fromJson(JsonReader reader) throws IOException {
            int index = reader.selectString(this.options);
            if (index != -1) {
                return this.constants[index];
            }
            String path = reader.getPath();
            String name = reader.nextString();
            throw new JsonDataException("Expected one of " + Arrays.asList(this.nameStrings) + " but was " + name + " at path " + path);
        }

        @Override
        public void toJson(JsonWriter writer, T value) throws IOException {
            writer.value(this.nameStrings[((Enum)value).ordinal()]);
        }

        public String toString() {
            return "JsonAdapter(" + this.enumType.getName() + ")";
        }
    }
}

