/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica.crosswalk;

import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import de.gwdg.metadataqa.marc.utils.pica.crosswalk.Crosswalk;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PicaMarcCrosswalkReader {
    private static List<Crosswalk> mapping;
    private static Map<String, List<Crosswalk>> marcIndex;
    private static Map<String, List<Crosswalk>> picaIndex;

    public static List<Crosswalk> read() {
        if (mapping == null) {
            PicaMarcCrosswalkReader.initialize();
        }
        return mapping;
    }

    public static List<Crosswalk> lookupMarc21(String key) {
        if (mapping == null) {
            PicaMarcCrosswalkReader.initialize();
        }
        return marcIndex.getOrDefault(key, new ArrayList());
    }

    public static List<Crosswalk> lookupPica(String key) {
        if (mapping == null) {
            PicaMarcCrosswalkReader.initialize();
        }
        return picaIndex.getOrDefault(key, new ArrayList());
    }

    private static void initialize() {
        InputStreamReader streamReader = new InputStreamReader(PicaMarcCrosswalkReader.class.getResourceAsStream("/pica/pica-marc.tsv"));
        CSVReader reader = new CSVReaderBuilder((Reader)streamReader).withCSVParser((ICSVParser)new CSVParserBuilder().withSeparator('\t').build()).withSkipLines(1).build();
        CsvToBean csvToBean = new CsvToBeanBuilder(reader).withType(Crosswalk.class).build();
        mapping = csvToBean.parse();
        PicaMarcCrosswalkReader.index();
    }

    private static void index() {
        marcIndex = new HashMap<String, List<Crosswalk>>();
        picaIndex = new HashMap<String, List<Crosswalk>>();
        for (Crosswalk crosswalk : mapping) {
            if (crosswalk.getMarc21() != null) {
                if (!marcIndex.containsKey(crosswalk.getMarc21())) {
                    marcIndex.put(crosswalk.getMarc21(), new ArrayList());
                }
                marcIndex.get(crosswalk.getMarc21()).add(crosswalk);
            }
            if (crosswalk.getPica() == null) continue;
            if (!picaIndex.containsKey(crosswalk.getPica())) {
                picaIndex.put(crosswalk.getPica(), new ArrayList());
            }
            picaIndex.get(crosswalk.getPica()).add(crosswalk);
        }
    }

    public static List<Crosswalk> lookupMarc21Field(String marcEntry) {
        ArrayList<Crosswalk> crosswalks = new ArrayList<Crosswalk>();
        for (Crosswalk crosswalk : mapping) {
            if (crosswalk.getMarc21() == null || !crosswalk.getMarc21().startsWith(marcEntry)) continue;
            crosswalks.add(crosswalk);
        }
        return crosswalks;
    }

    static {
        PicaMarcCrosswalkReader.initialize();
    }
}

