/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.bibliographic.BibliographicFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaRange;
import de.gwdg.metadataqa.marc.utils.pica.PicaplusTag;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PicaTagDefinition
implements BibliographicFieldDefinition {
    private static final Logger logger = Logger.getLogger(PicaTagDefinition.class.getCanonicalName());
    private static final Pattern rangePattern = Pattern.compile("^(\\d+)-(\\d+)$");
    private PicaplusTag tag;
    private final String pica3;
    private Boolean repeatable;
    private Cardinality cardinality;
    private Boolean hasSheet;
    private final String label;
    protected String descriptionUrl;
    protected List<SubfieldDefinition> subfields;
    private String modified;
    private String occurrence;
    private PicaRange range;
    private String id;
    private String counter;

    public PicaTagDefinition(String pica3, String picaplus, boolean repeatable, boolean sheet, String label) {
        this.pica3 = pica3;
        this.tag = new PicaplusTag(picaplus);
        this.repeatable = repeatable;
        this.cardinality = repeatable ? Cardinality.Repeatable : Cardinality.Nonrepeatable;
        this.hasSheet = sheet;
        this.label = label;
    }

    public PicaTagDefinition(String[] input) {
        this.pica3 = input[0];
        this.tag = new PicaplusTag(input[1]);
        this.label = input[4];
        this.parseRepeatable(input[2]);
        this.parseSheet(input[3]);
    }

    public PicaplusTag getPicaplusTag() {
        return this.tag;
    }

    private void parseSheet(String input) {
        switch (input) {
            case "": 
            case "-": {
                this.hasSheet = false;
                break;
            }
            case "+": {
                this.hasSheet = true;
                break;
            }
            default: {
                logger.severe(String.format("unhandled 'hasSheet' value: %s (%s)", input, this.tag.getRaw()));
            }
        }
    }

    private void parseRepeatable(String input) {
        switch (input) {
            case "": {
                this.repeatable = false;
                break;
            }
            case "*": {
                this.repeatable = true;
                break;
            }
            default: {
                logger.severe("unhandled 'repeatable' value: " + input);
            }
        }
        this.cardinality = this.repeatable != false ? Cardinality.Repeatable : Cardinality.Nonrepeatable;
    }

    public String getPica3() {
        return this.pica3;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isHasSheet() {
        return this.hasSheet;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getTag() {
        return this.tag.getTag();
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public List<SubfieldDefinition> getSubfields() {
        return this.subfields;
    }

    public void setSubfields(List<SubfieldDefinition> subfields) {
        this.subfields = subfields;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public void setDescriptionUrl(String descriptionUrl) {
        this.descriptionUrl = descriptionUrl;
    }

    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public void setCounter(String counter) {
        this.counter = counter;
        if (counter != null) {
            this.range = new PicaRange(counter);
        }
    }

    public String getCounter() {
        return this.counter;
    }

    public PicaRange getRange() {
        return this.range;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setOccurrence(String occurrence) {
        this.occurrence = occurrence;
        if (occurrence != null) {
            this.range = new PicaRange(occurrence);
        }
    }

    public String toString() {
        return "PicaTagDefinition{pica3='" + this.pica3 + "', picaplus='" + this.tag.getRaw() + "', repeatable=" + this.repeatable + ", hasSheet=" + this.hasSheet + ", description='" + this.label + "'}";
    }
}

