/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

public class PicaRange {
    private String raw;
    private String start;
    private String end;
    private Integer unitLength = null;
    private boolean hasRange;

    public PicaRange(String raw) {
        this.raw = raw;
        if (raw != null) {
            this.parse();
        }
    }

    private void parse() {
        String[] parts = this.raw.split("-");
        this.hasRange = parts.length == 2;
        this.start = parts[0];
        if (this.hasRange) {
            this.end = parts[1];
        }
        this.unitLength = this.start.length();
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public int getUnitLength() {
        return this.unitLength == null ? 0 : this.unitLength;
    }

    public boolean isHasRange() {
        return this.hasRange;
    }

    public boolean isNull() {
        return this.raw == null;
    }

    public String toString() {
        return "PicaRange{raw='" + this.raw + "', start='" + this.start + "', end='" + this.end + "', unitLength=" + this.unitLength + ", hasRange=" + this.hasRange + "}";
    }
}

