/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.pica.PicaLine;
import de.gwdg.metadataqa.marc.utils.pica.PicaReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class PicaPlainReader
extends PicaReader {
    private static final Logger logger = Logger.getLogger(PicaPlainReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private int lineNumber = 0;
    private List<PicaLine> lines = new ArrayList<PicaLine>();
    private String defauultSubfieldSeparator = "$";

    public PicaPlainReader(String fileName) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in PicaReader()", e);
        }
    }

    public PicaPlainReader(InputStream stream, String encoding) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader(stream, encoding));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in PicaReader()", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.lineNumber == 0) {
            this.checkSubfieldSeparator();
        }
        if (this.lineNumber == 0) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error in hasNext()", e);
            }
            ++this.lineNumber;
        }
        return this.line != null;
    }

    @Override
    public Record next() {
        Record marc4jRecord = null;
        boolean finished = false;
        while (this.line != null && !finished) {
            PicaLine picaLine = new PicaLine(this.line, this.subfieldSeparator);
            if (picaLine.isSkippable() && !this.lines.isEmpty()) {
                if (!this.parsed && StringUtils.isNotEmpty((CharSequence)this.idField) && StringUtils.isNotBlank((CharSequence)this.idField)) {
                    this.parseIdField();
                }
                marc4jRecord = MarcFactory.createRecordFromPica(this.lines, this.idTag, this.idCode, this.schema);
                finished = true;
                this.lines = new ArrayList<PicaLine>();
            }
            if (picaLine.isValidTag()) {
                this.lines.add(picaLine);
            }
            try {
                this.line = this.bufferedReader.readLine();
                ++this.lineNumber;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "next", e);
            }
        }
        if (this.line == null && !this.lines.isEmpty()) {
            marc4jRecord = MarcFactory.createRecordFromPica(this.lines, this.idTag, this.idCode, this.schema);
        }
        return marc4jRecord;
    }

    private void checkSubfieldSeparator() {
        if (this.subfieldSeparator == null) {
            this.subfieldSeparator = this.defauultSubfieldSeparator;
        }
    }
}

