/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.pica.PicaLine;
import de.gwdg.metadataqa.marc.utils.pica.PicaReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.marc4j.marc.Record;

public class PicaNormalizedReader
extends PicaReader {
    private static final Logger logger = Logger.getLogger(PicaNormalizedReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private List<PicaLine> lines = new ArrayList<PicaLine>();
    private String fieldSeparator = "\u001e";
    private String subfieldSeparator = "\u001f";
    private String defauultSubfieldSeparator = "\u001f";

    public PicaNormalizedReader(String fileName) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in PicaReader()", e);
        }
    }

    public PicaNormalizedReader(InputStream stream, String encoding) {
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader(stream, encoding));
            this.parseIdField();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in PicaReader()", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.line == null) {
            this.checkSubfieldSeparator();
        }
        try {
            this.line = this.bufferedReader.readLine();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in hasNext()", e);
        }
        return this.line != null;
    }

    @Override
    public Record next() {
        Record marc4jRecord = null;
        String[] fields = this.line.split(Pattern.quote(this.fieldSeparator));
        this.lines = new ArrayList<PicaLine>();
        for (String field : fields) {
            PicaLine picaLine = new PicaLine(field, this.subfieldSeparator);
            if (!picaLine.isValidTag()) continue;
            this.lines.add(picaLine);
        }
        marc4jRecord = MarcFactory.createRecordFromPica(this.lines, this.idTag, this.idCode, this.schema);
        return marc4jRecord;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    private void checkSubfieldSeparator() {
        if (this.subfieldSeparator == null) {
            this.subfieldSeparator = this.defauultSubfieldSeparator;
        }
    }
}

