/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaRange;
import de.gwdg.metadataqa.marc.utils.pica.PicaTagDefinition;

public class PicaFieldDefinition
extends DataFieldDefinition {
    private String modified;
    private String pica3;
    private String occurrence;
    private PicaRange range;
    private String id;

    private PicaFieldDefinition() {
    }

    public PicaFieldDefinition(PicaTagDefinition picaTagDefinition) {
        this.tag = picaTagDefinition.getTag();
        this.label = picaTagDefinition.getLabel();
        this.cardinality = picaTagDefinition.getCardinality();
        this.subfields = picaTagDefinition.getSubfields();
        this.descriptionUrl = picaTagDefinition.getDescriptionUrl();
        this.modified = picaTagDefinition.getModified();
        this.pica3 = picaTagDefinition.getPica3();
        this.occurrence = picaTagDefinition.getOccurrence();
        this.id = picaTagDefinition.getId();
        this.range = picaTagDefinition.getRange();
        this.indexSubfields();
    }

    public String getModified() {
        return this.modified;
    }

    public String getPica3() {
        return this.pica3;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public PicaRange getRange() {
        return this.range;
    }

    public String getId() {
        return this.id;
    }

    public boolean inRange(String occurence) {
        if (this.range != null && this.range.getUnitLength() == occurence.length()) {
            if (this.range.isHasRange()) {
                return this.range.getStart().compareTo(occurence) != 1 && this.range.getEnd().compareTo(occurence) != -1;
            }
            return this.range.getStart().equals(occurence);
        }
        return false;
    }

    public PicaFieldDefinition copyWithChangesId() {
        PicaFieldDefinition other = new PicaFieldDefinition();
        other.id = this.getId().replace("/00", "");
        other.tag = this.getTag();
        other.label = this.getLabel();
        other.cardinality = this.getCardinality();
        other.subfields = this.getSubfields();
        other.descriptionUrl = this.getDescriptionUrl();
        other.modified = this.getModified();
        other.pica3 = this.getPica3();
        other.occurrence = this.getOccurrence();
        other.range = this.getRange();
        other.indexSubfields();
        return other;
    }
}

