/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

public class OccurrenceRange {
    private int unitLength = 0;
    private int start;
    private int end;
    private final String format;

    public OccurrenceRange(int unitLength, int start, int end) {
        this.unitLength = unitLength;
        this.start = start;
        this.end = end;
        this.format = "%0" + unitLength + "d";
    }

    public int getUnitLength() {
        return this.unitLength;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return String.format(this.format + "-" + this.format, this.start, this.end);
    }

    public boolean validate(String occurrence) {
        if (occurrence.length() != this.unitLength) {
            return false;
        }
        try {
            int number = Integer.parseInt(occurrence);
            return this.start <= number && number <= this.end;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

