/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.alephseq;

import de.gwdg.metadataqa.marc.dao.DataField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AlephseqLine {
    private static final Logger logger = Logger.getLogger(AlephseqLine.class.getCanonicalName());
    private static final String LDR = "LDR";
    private static final Pattern numericTag = Pattern.compile("^\\d\\d\\d$");
    private static final Pattern controlField = Pattern.compile("^00\\d$");
    public static final String SEPARATOR = "\\$\\$";
    private int lineNumber = 0;
    private String recordID;
    private String tag;
    private String ind1;
    private String ind2;
    private String content;
    private boolean valid = true;
    private TYPE type = TYPE.WITH_L;
    private Integer contentPosition;

    public AlephseqLine() {
    }

    public AlephseqLine(String raw) {
        this.parse(raw);
    }

    public AlephseqLine(String raw, TYPE type) {
        this.type = type;
        this.parse(raw);
    }

    public AlephseqLine(String raw, int lineNumber) {
        this.lineNumber = lineNumber;
        this.parse(raw);
    }

    public AlephseqLine(String raw, int lineNumber, TYPE type) {
        this.lineNumber = lineNumber;
        this.type = type;
        this.parse(raw);
    }

    public boolean isLeader() {
        if (this.tag == null) {
            return false;
        }
        return this.tag.equals(LDR);
    }

    public boolean isNumericTag() {
        if (this.tag == null) {
            return false;
        }
        return numericTag.matcher(this.tag).matches();
    }

    public boolean isControlField() {
        if (this.tag == null) {
            return false;
        }
        return controlField.matcher(this.tag).matches();
    }

    public boolean isValidTag() {
        return this.isValid() && (this.isLeader() || this.isNumericTag());
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String getTag() {
        return this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public String getContent() {
        if (this.content == null) {
            return this.content;
        }
        if (this.isLeader() || this.isControlField()) {
            return this.content.replace("^", " ");
        }
        return this.content.replace("$$", "$");
    }

    public String getRawContent() {
        return this.content;
    }

    private void parse(String raw) {
        if (raw.length() < 18) {
            logger.warning(String.format("%d) short line (%d): '%s'", this.lineNumber, raw.length(), raw));
            this.valid = false;
        } else {
            String[] parts = raw.split(" ", 2);
            this.recordID = parts[0];
            this.tag = parts[1].substring(0, 3);
            this.ind1 = parts[1].substring(3, 4);
            this.ind2 = parts[1].substring(4, 5);
            this.content = parts[1].substring(this.getContentPosition());
        }
    }

    public List<String[]> parseSubfields() {
        String[] segments;
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        for (String segment : segments = this.content.split(SEPARATOR)) {
            if (!StringUtils.isNotBlank((CharSequence)segment)) continue;
            subfields.add(new String[]{segment.substring(0, 1), segment.substring(1)});
        }
        return subfields;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "AlephseqLine{recordID='" + this.recordID + "', tag='" + this.tag + "', ind1='" + this.ind1 + "', ind2='" + this.ind2 + "', content='" + this.getContent() + "'}";
    }

    public List<String[]> getSubfields() {
        return DataField.parseSubfields(this.getContent());
    }

    private int getContentPosition() {
        if (this.contentPosition == null) {
            this.contentPosition = this.type.equals((Object)TYPE.WITH_L) ? 8 : 6;
        }
        return this.contentPosition;
    }

    public static enum TYPE {
        WITH_L,
        WITHOUT_L;

    }
}

