/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag533
extends DataFieldDefinition {
    private static Tag533 uniqueInstance;

    private Tag533() {
        this.initialize();
        this.postCreation();
    }

    public static Tag533 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag533();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "533";
        this.label = "Reproduction Note";
        this.mqTag = "Reproduction";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd533.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Type of reproduction", "NR", "b", "Place of reproduction", "R", "c", "Agency responsible for reproduction", "R", "d", "Date of reproduction", "NR", "e", "Physical description of reproduction", "NR", "f", "Series statement of reproduction", "R", "m", "Dates and/or sequential designation of issues reproduced", "R", "n", "Note about reproduction", "R", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "7", "Fixed-length data elements of reproduction", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("type").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M", "M");
        this.getSubfield("b").setMqTag("place").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("c").setMqTag("agency").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("d").setMqTag("date").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("e").setMqTag("physicalDescription").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("f").setMqTag("series").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("m").setMqTag("datesAndOrSequentialDesignation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A", "A");
        this.getSubfield("n").setMqTag("note").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("7").setMqTag("controlSubfield").setCompilanceLevels("O");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

