/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag532
extends DataFieldDefinition {
    private static Tag532 uniqueInstance;

    private Tag532() {
        this.initialize();
        this.postCreation();
    }

    public static Tag532 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag532();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "532";
        this.label = "Accessibility Note";
        this.mqTag = "AccessibilityNote";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd532.html";
        this.ind1 = new Indicator("Display constant controller").setCodes("0", "Accessibility technical details", "1", "Accessibility features", "2", "Accessibility deficiencies", "8", "No display constant generated").setMqTag("displayConstantController");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Summary of accessibility", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("summary");
        this.getSubfield("6").setBibframeTag("linkage").setContentParser(LinkageParser.getInstance());
        this.getSubfield("8").setMqTag("fieldLink");
        this.setHistoricalSubfields("z", "Source of note information (AM, CF, VM, SE) [OBSOLETE, 1990]");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

