/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags4xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag400
extends DataFieldDefinition {
    private static Tag400 uniqueInstance;

    private Tag400() {
        this.initialize();
        this.postCreation();
    }

    public static Tag400 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag400();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "400";
        this.label = "Series Statement/Added Entry-Personal Name";
        this.mqTag = "SeriesStatementAddedEntryPersonalName";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd400.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Type of personal name entry element").setCodes("0", "Forename", "1", "Surname", "3", "Family name").setMqTag("type");
        this.ind2 = new Indicator("Pronoun represents main entry").setCodes("0", "Main entry not represented by pronoun", "1", "Main entry represented by pronoun").setMqTag("pronounRepresentsMainEntry");
        this.setSubfieldsWithCardinality("a", "Personal name", "NR", "b", "Numeration", "NR", "c", "Titles and other words associated with a name", "R", "d", "Dates associated with a name", "NR", "e", "Relator term", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "NR", "k", "Form subheading", "R", "l", "Language of a work", "NR", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "t", "Title of a work", "NR", "u", "Affiliation", "NR", "v", "Volume/sequential designation", "NR", "x", "International Standard Serial Number", "NR", "4", "Relator code", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("rdf:value");
        this.getSubfield("b").setMqTag("numeration");
        this.getSubfield("c").setMqTag("titles");
        this.getSubfield("d").setMqTag("dates");
        this.getSubfield("e").setMqTag("relator");
        this.getSubfield("f").setMqTag("dateOfAWork");
        this.getSubfield("g").setMqTag("miscellaneous");
        this.getSubfield("k").setMqTag("formSubheading");
        this.getSubfield("l").setMqTag("languageOfAWork");
        this.getSubfield("n").setMqTag("numberOfPart");
        this.getSubfield("p").setMqTag("nameOfPart");
        this.getSubfield("t").setMqTag("title");
        this.getSubfield("u").setMqTag("affiliation");
        this.getSubfield("v").setMqTag("volume");
        this.getSubfield("x").setMqTag("issn");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

