/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.PriceTypeCodeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag365
extends DataFieldDefinition {
    private static Tag365 uniqueInstance;

    private Tag365() {
        this.initialize();
        this.postCreation();
    }

    public static Tag365 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag365();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "365";
        this.label = "Trade Price";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd365.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Start/End designator").setCodes(" ", "No information provided", "0", "Starting information", "1", "Ending information");
        this.ind2 = new Indicator("State of issuance").setCodes(" ", "Not specified", "0", "Closed", "1", "Open");
        this.setSubfieldsWithCardinality("a", "Price type code", "NR", "b", "Price amount", "NR", "c", "Currency code", "NR", "d", "Unit of pricing", "NR", "e", "Price note", "NR", "f", "Price effective from", "NR", "g", "Price effective until", "NR", "h", "Tax rate 1", "NR", "i", "Tax rate 2", "NR", "j", "ISO country code", "NR", "k", "MARC country code", "NR", "m", "Identification of pricing entity", "NR", "2", "Source of price type code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("d").setCodes("00", "Per copy of whole product [default value]", "01", "Per page for printed loose-leaf content only");
        this.getSubfield("k").setCodeList(CountryCodes.getInstance());
        this.getSubfield("2").setCodeList(PriceTypeCodeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("priceTypeCode").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("priceAmount").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("currencyCode").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("unitOfPricing").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.UseInterpret, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("priceNote").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("priceEffectiveFrom").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("priceEffectiveUntil").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("taxRate1").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("taxRate2").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("isoCountryCode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("marcCountryCode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("identificationOfPricingEntity").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

