/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.bltags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.validator.RegexValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag692
extends DataFieldDefinition {
    private static Tag692 uniqueInstance;

    private Tag692() {
        this.initialize();
        this.postCreation();
    }

    public static Tag692 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag692();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "692";
        this.label = "Nineteenth Century Subject Series Field";
        this.mqTag = "CollectionSubset";
        this.cardinality = Cardinality.Repeatable;
        this.obsolete = true;
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "General Collection subject code", "NR", "b", "Linguistics collection code", "NR", "c", "Visual Arts and Architecture collection code", "NR", "e", "Publishing, the Book Trade & the Diffusion of Knowledge collection code", "NR", "f", "Women Writers collection code", "NR", "g", "Children\u2019s Literature collection code", "NR", "i", "Nineteenth Century Books on China collection code", "NR", "p", "Year code", "NR");
        this.getSubfield("a").setCodes("Agr", "Agriculture", "Eco", "Economics", "Edu", "Education", "Geo", "Geography and topography", "His", "History and archaeology", "HoM", "Household management", "Jur", "Jurisprudence", "Med", "Medicine", "Phi", "Philosophy", "Pol", "Politics", "Psy", "Psychology", "Rec", "Recreation", "Rel", "Religion", "Sci", "Science", "UsA", "Useful arts").setMqTag("general");
        this.getSubfield("b").setCodes("L", "L").setMqTag("linguistics");
        this.getSubfield("c").setCodes("A", "A").setMqTag("visualArtsAndArchitecture");
        this.getSubfield("e").setCodes("B", "B").setMqTag("publishing");
        this.getSubfield("f").setCodes("W", "W").setMqTag("womenWriters");
        this.getSubfield("g").setCodes("C", "C").setMqTag("children");
        this.getSubfield("i").setCodes("AS", "Anthropology & society", "CE", "Economics & commerce", "GS", "Geography", "HS", "History of China", "LA", "Literature & the arts", "PG", "Politics & government", "RP", "Religion and philosophy").setMqTag("onChina");
        this.getSubfield("p").setValidator(new RegexValidator("^(x|\\d\\((\\d{2}/\\d{2}|\\d{2}-\\d{2})\\))$")).setMqTag("year");
    }
}

