/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.parser;

import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class YYYYMMDDDateParser
implements SubfieldContentParser,
Serializable {
    private String dateFormat = "yyyyMMdd";
    private DateTimeFormatter marc;
    DateTimeFormatter iso = DateTimeFormatter.ISO_DATE;
    private static YYYYMMDDDateParser uniqueInstance;

    private YYYYMMDDDateParser() {
        this.initialize();
    }

    public static YYYYMMDDDateParser getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new YYYYMMDDDateParser();
        }
        return uniqueInstance;
    }

    public YYYYMMDDDateParser(String dateFormat) {
        this.dateFormat = dateFormat;
        this.initialize();
    }

    private void initialize() {
        this.marc = DateTimeFormatter.ofPattern(this.dateFormat, Locale.getDefault());
    }

    @Override
    public Map<String, String> parse(String content) throws ParserException {
        HashMap<String, String> extra = new HashMap<String, String>();
        try {
            LocalDate date = LocalDate.parse(content, this.marc);
            extra.put("normalized", date.format(this.iso));
        }
        catch (DateTimeParseException e) {
            throw new ParserException(String.format("Invalid content: '%s'. %s", content, e.getMessage()));
        }
        return extra;
    }
}

