/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.codelist;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.Validator;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeList
implements Validator,
Serializable {
    protected String name;
    protected String url;
    protected List<EncodedValue> codes;
    protected Map<String, EncodedValue> index = new HashMap<String, EncodedValue>();

    protected void indexCodes() {
        for (EncodedValue code : this.codes) {
            this.index.put(code.getCode(), code);
        }
    }

    public List<EncodedValue> getCodes() {
        return this.codes;
    }

    public EncodedValue getCode(String code) {
        return this.index.getOrDefault(code, null);
    }

    @Override
    public boolean isValid(String code) {
        return this.index.containsKey(code);
    }

    @Override
    public boolean isValid(String code, MarcSubfield field) {
        return this.index.containsKey(code);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return null;
    }
}

