/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao.record;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.AuthorityCategory;
import de.gwdg.metadataqa.marc.analysis.ShelfReadyFieldsBooks;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.dao.record.Marc21Record;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.utils.pica.crosswalk.Crosswalk;
import de.gwdg.metadataqa.marc.utils.pica.crosswalk.PicaMarcCrosswalkReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PicaRecord
extends BibliographicRecord {
    private static List<String> authorityTags;
    private static List<String> subjectTags;
    private static Map<String, Boolean> authorityTagsIndex;
    private static Map<String, Boolean> subjectTagIndex;
    private static Map<String, Map<String, Boolean>> skippableAuthoritySubfields;
    private static Map<String, Map<String, Boolean>> skippableSubjectSubfields;
    private static Map<AuthorityCategory, List<String>> authorityTagsMap;
    private static Map<ThompsonTraillFields, List<String>> thompsonTraillTagMap;
    private static Map<ShelfReadyFieldsBooks, Map<String, List<String>>> shelfReadyMap;

    public PicaRecord() {
        this.init();
    }

    public PicaRecord(String id) {
        super(id);
        this.init();
    }

    private void init() {
        this.schemaType = SchemaType.PICA;
    }

    @Override
    public List<DataField> getAuthorityFields() {
        if (authorityTags == null) {
            PicaRecord.initializeAuthorityTags();
        }
        return this.getAuthorityFields(authorityTags);
    }

    @Override
    public boolean isAuthorityTag(String tag) {
        if (authorityTagsIndex == null) {
            PicaRecord.initializeAuthorityTags();
        }
        return authorityTagsIndex.getOrDefault(tag, false);
    }

    @Override
    public boolean isSkippableAuthoritySubfield(String tag, String code) {
        if (authorityTagsIndex == null) {
            PicaRecord.initializeAuthorityTags();
        }
        if (!skippableAuthoritySubfields.containsKey(tag)) {
            return false;
        }
        return skippableAuthoritySubfields.get(tag).getOrDefault(code, false);
    }

    @Override
    public boolean isSubjectTag(String tag) {
        if (subjectTagIndex == null) {
            PicaRecord.initializeAuthorityTags();
        }
        return subjectTagIndex.getOrDefault(tag, false);
    }

    @Override
    public boolean isSkippableSubjectSubfield(String tag, String code) {
        if (subjectTagIndex == null) {
            PicaRecord.initializeAuthorityTags();
        }
        if (!skippableSubjectSubfields.containsKey(tag)) {
            return false;
        }
        return skippableSubjectSubfields.get(tag).getOrDefault(code, false);
    }

    @Override
    public Map<DataField, AuthorityCategory> getAuthorityFieldsMap() {
        if (authorityTags == null) {
            PicaRecord.initializeAuthorityTags();
        }
        return this.getAuthorityFields(authorityTagsMap);
    }

    @Override
    public Map<ShelfReadyFieldsBooks, Map<String, List<String>>> getShelfReadyMap() {
        if (shelfReadyMap == null) {
            PicaRecord.initializeShelfReadyMap();
        }
        return shelfReadyMap;
    }

    private static void initializeAuthorityTags() {
        authorityTags = Arrays.asList("022A", "022A", "028A", "028B", "028C", "028E", "028G", "029A", "029E", "029F", "029G", "032V", "032W", "032X", "033D", "033H", "033J", "037Q", "037R");
        authorityTagsIndex = Utils.listToMap(authorityTags);
        skippableAuthoritySubfields = new HashMap<String, Map<String, Boolean>>();
        skippableAuthoritySubfields.put("022A", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("028A", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("028B", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("028C", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("028E", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("028G", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("029A", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("029E", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("029F", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("029G", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("033D", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("033H", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableAuthoritySubfields.put("033J", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        subjectTags = Arrays.asList("045A", "045B", "045F", "045R", "045C", "045E", "045G");
        subjectTagIndex = Utils.listToMap(subjectTags);
        skippableSubjectSubfields = new HashMap<String, Map<String, Boolean>>();
        skippableSubjectSubfields.put("022A", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        skippableSubjectSubfields.put("045R", Utils.listToMap(Arrays.asList("9", "V", "7", "3", "w")));
        authorityTagsMap = new HashMap<AuthorityCategory, List<String>>();
        authorityTagsMap.put(AuthorityCategory.Titles, List.of("022A", "022A"));
        authorityTagsMap.put(AuthorityCategory.Personal, List.of("028A", "028B", "028C", "028E", "028G", "033J"));
        authorityTagsMap.put(AuthorityCategory.Corporate, List.of("029A", "029E", "029F", "029G"));
        authorityTagsMap.put(AuthorityCategory.Other, List.of("032V", "032W", "032X", "037Q", "037R"));
        authorityTagsMap.put(AuthorityCategory.Geographic, List.of("033D", "033H"));
    }

    private static void initializeShelfReadyMap() {
        shelfReadyMap = new LinkedHashMap<ShelfReadyFieldsBooks, Map<String, List<String>>>();
        for (Map.Entry<ShelfReadyFieldsBooks, Map<String, List<String>>> entry : new Marc21Record().getShelfReadyMap().entrySet()) {
            ShelfReadyFieldsBooks category = entry.getKey();
            shelfReadyMap.put(category, new HashMap());
            for (Map.Entry<String, List<String>> marcEntry : entry.getValue().entrySet()) {
                for (String code : marcEntry.getValue()) {
                    for (Crosswalk crosswalk : PicaMarcCrosswalkReader.lookupMarc21(marcEntry.getKey() + " $" + code)) {
                        if (!shelfReadyMap.get((Object)category).containsKey(crosswalk.getPica())) {
                            shelfReadyMap.get((Object)category).put(crosswalk.getPica(), new ArrayList());
                        }
                        shelfReadyMap.get((Object)category).get(crosswalk.getPica()).add(crosswalk.getPicaUf().replace("$", ""));
                    }
                }
            }
        }
    }

    @Override
    public Map<ThompsonTraillFields, List<String>> getThompsonTraillTagsMap() {
        if (thompsonTraillTagMap == null) {
            this.initializeThompsonTrailTags();
        }
        return thompsonTraillTagMap;
    }

    private void initializeThompsonTrailTags() {
        thompsonTraillTagMap = new LinkedHashMap<ThompsonTraillFields, List<String>>();
        for (Map.Entry<ThompsonTraillFields, List<String>> entry : new Marc21Record().getThompsonTraillTagsMap().entrySet()) {
            ThompsonTraillFields category = entry.getKey();
            thompsonTraillTagMap.put(category, new ArrayList());
            for (String marcEntry : entry.getValue()) {
                for (Crosswalk crosswalk : PicaMarcCrosswalkReader.lookupMarc21Field(marcEntry)) {
                    if (thompsonTraillTagMap.get((Object)category).contains(crosswalk.getPica())) continue;
                    thompsonTraillTagMap.get((Object)category).add(crosswalk.getPica());
                }
            }
        }
    }
}

