/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils.ignorablerecords;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilter;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilterMarc21;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilterPica;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;

public class RecordFilterFactory {
    private RecordFilterFactory() {
    }

    public static RecordFilter create(SchemaType type, String allowableRecordsInput) {
        if (allowableRecordsInput.startsWith("base64:")) {
            allowableRecordsInput = Utils.base64decode(allowableRecordsInput);
        }
        if (type.equals((Object)SchemaType.MARC21)) {
            return new RecordFilterMarc21(allowableRecordsInput);
        }
        if (type.equals((Object)SchemaType.PICA)) {
            return new RecordFilterPica(allowableRecordsInput);
        }
        throw new IllegalArgumentException("Unsupported schema type");
    }
}

