/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.api.model.pathcache.JsonPathCache;
import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.datastore.MarcSolrClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrServerException;

public class MarcJsonToSolr {
    private static final Logger logger = Logger.getLogger(MarcJsonToSolr.class.getCanonicalName());

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Please provide a Solr URL and file name!");
            System.exit(0);
        }
        long start = System.currentTimeMillis();
        String url = args[0];
        String relativeFileName = args[1];
        Path path = Paths.get(relativeFileName, new String[0]);
        String fileName = path.getFileName().toString();
        boolean doCommits = true;
        if (args.length > 2) {
            if (args[2].equals("doCommit=true")) {
                doCommits = true;
            } else if (args[2].equals("doCommit=false")) {
                doCommits = false;
            }
        }
        logger.info(String.format("Solr URL: %s, file: %s (do commits: %s)", url, fileName, doCommits));
        MarcSolrClient client = new MarcSolrClient(url);
        try {
            List<String> records = Files.readAllLines(path, Charset.defaultCharset());
            int i = 0;
            for (String marcRecordLine : records) {
                JsonPathCache cache = new JsonPathCache(marcRecordLine);
                BibliographicRecord marcRecord = MarcFactory.create(cache);
                client.indexMap(marcRecord.getId(), marcRecord.getKeyValuePairs());
                if (++i % 1000 != 0) continue;
                if (doCommits) {
                    client.commit();
                }
                logger.info(String.format("%s/%d) %s", fileName, i, marcRecord.getId()));
            }
            if (doCommits) {
                client.commit();
            }
            logger.info("end of cycle");
        }
        catch (IOException | SolrServerException ex) {
            logger.severe(ex.toString());
            System.exit(0);
        }
        long end = System.currentTimeMillis();
        logger.info(String.format("Bye! It took: %.1f s", Float.valueOf((float)(end - start) / 1000.0f)));
        System.exit(0);
    }
}

