/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.cli.parameters.MappingParameters;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control006Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control007Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control008Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.ControlfieldPositionList;
import de.gwdg.metadataqa.marc.definition.controlpositions.LeaderPositions;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.structure.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control001Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control003Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control005Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control006Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control007Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control008Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.LeaderDefinition;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import de.gwdg.metadataqa.marc.utils.keygenerator.PositionalControlFieldKeyGenerator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minidev.json.JSONValue;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MappingToJson {
    private static final Logger logger = Logger.getLogger(MappingToJson.class.getCanonicalName());
    private boolean exportSubfieldCodes = false;
    private boolean exportSelfDescriptiveCodes = false;
    private Map<String, Object> mapping;
    private final Options options;
    private MappingParameters parameters;

    public MappingToJson(String[] args) throws ParseException {
        this.parameters = new MappingParameters(args);
        this.options = this.parameters.getOptions();
        this.exportSubfieldCodes = this.parameters.doExportSubfieldCodes();
        this.exportSelfDescriptiveCodes = this.parameters.doExportSelfDescriptiveCodes();
        this.mapping = new LinkedHashMap<String, Object>();
        this.mapping.put("$schema", "https://format.gbv.de/schema/avram/schema.json");
        this.mapping.put("title", "MARC 21 Format for Bibliographic Data.");
        this.mapping.put("description", "MARC 21 Format for Bibliographic Data.");
        this.mapping.put("url", "https://www.loc.gov/marc/bibliographic/");
    }

    public void setExportSubfieldCodes(boolean exportSubfieldCodes) {
        this.exportSubfieldCodes = exportSubfieldCodes;
    }

    public String toJson() {
        return JSONValue.toJSONString(this.mapping);
    }

    public void build() {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        fields.put("LDR", this.buildLeader());
        fields.putAll(this.buildSimpleControlFields());
        fields.put("006", this.buildControlField(Control006Definition.getInstance(), Control006Positions.getInstance()));
        fields.put("007", this.buildControlField(Control007Definition.getInstance(), Control007Positions.getInstance()));
        fields.put("008", this.buildControlField(Control008Definition.getInstance(), Control008Positions.getInstance()));
        for (Class<? extends DataFieldDefinition> tagClass : MarcTagLister.listTags()) {
            try {
                Method getInstance = tagClass.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke(tagClass, new Object[0]);
                if (!this.parameters.isWithLocallyDefinedFields() && !fieldTag.getMarcVersion().equals((Object)MarcVersion.MARC21)) continue;
                this.dataFieldToJson(fields, fieldTag);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.log(Level.SEVERE, "build", e);
            }
        }
        this.mapping.put("fields", fields);
    }

    private Map<String, Object> buildControlField(ControlFieldDefinition field, ControlfieldPositionList positionDefinition) {
        LinkedHashMap<String, Object> tag = new LinkedHashMap<String, Object>();
        tag.put("tag", field.getTag());
        tag.put("label", field.getLabel());
        tag.put("repeatable", this.resolveCardinality(field.getCardinality()));
        LinkedHashMap types = new LinkedHashMap();
        PositionalControlFieldKeyGenerator generator = this.getPositionalControlFieldKeyGenerator(field);
        for (String type : positionDefinition.getPositions().keySet()) {
            LinkedHashMap typeMap = new LinkedHashMap();
            LinkedHashMap<String, Map<String, Object>> positions = new LinkedHashMap<String, Map<String, Object>>();
            for (ControlfieldPositionDefinition subfield : positionDefinition.getPositions().get(type)) {
                Map<String, Object> position = MappingToJson.controlPositionToJson(subfield, generator);
                String key = (String)position.remove("position");
                positions.put(key, position);
            }
            typeMap.put("positions", positions);
            types.put(type, typeMap);
        }
        tag.put("types", types);
        return tag;
    }

    private Map<String, Object> buildSimpleControlFields() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        List<DataFieldDefinition> simpleControlFields = Arrays.asList(Control001Definition.getInstance(), Control003Definition.getInstance(), Control005Definition.getInstance());
        for (DataFieldDefinition field : simpleControlFields) {
            fields.put(field.getTag(), this.buildSImpleControlField(field));
        }
        return fields;
    }

    private Map<String, Object> buildSImpleControlField(DataFieldDefinition field) {
        PositionalControlFieldKeyGenerator keyGenerator = new PositionalControlFieldKeyGenerator(field.getTag(), field.getMqTag(), this.parameters.getSolrFieldType());
        LinkedHashMap<String, Object> tag = new LinkedHashMap<String, Object>();
        tag.put("tag", field.getTag());
        tag.put("label", field.getLabel());
        tag.put("repeatable", this.resolveCardinality(field.getCardinality()));
        if (this.exportSelfDescriptiveCodes) {
            tag.put("solr", keyGenerator.forTag());
        }
        return tag;
    }

    private Map<String, Object> buildLeader() {
        LinkedHashMap<String, Object> tag = new LinkedHashMap<String, Object>();
        tag.put("repeatable", false);
        LinkedHashMap<String, Map<String, Object>> positions = new LinkedHashMap<String, Map<String, Object>>();
        LeaderDefinition field = LeaderDefinition.getInstance();
        PositionalControlFieldKeyGenerator generator = this.getPositionalControlFieldKeyGenerator(field);
        LeaderPositions leaderSubfields = LeaderPositions.getInstance();
        for (ControlfieldPositionDefinition subfield : leaderSubfields.getPositionList()) {
            Map<String, Object> position = MappingToJson.controlPositionToJson(subfield, generator);
            String key = (String)position.remove("position");
            positions.put(key, position);
        }
        tag.put("positions", positions);
        return tag;
    }

    private PositionalControlFieldKeyGenerator getPositionalControlFieldKeyGenerator(ControlFieldDefinition field) {
        PositionalControlFieldKeyGenerator generator = this.exportSelfDescriptiveCodes ? new PositionalControlFieldKeyGenerator(field.getTag(), field.getMqTag(), this.parameters.getSolrFieldType()) : null;
        return generator;
    }

    private static Map<String, Object> controlPositionToJson(ControlfieldPositionDefinition subfield, PositionalControlFieldKeyGenerator generator) {
        LinkedHashMap<String, String> codeMap;
        LinkedHashMap codes;
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("position", subfield.formatPositon());
        values.put("label", subfield.getLabel());
        values.put("url", subfield.getDescriptionUrl());
        values.put("start", subfield.getPositionStart());
        values.put("end", subfield.getPositionEnd());
        values.put("repeatableContent", subfield.isRepeatableContent());
        if (subfield.isRepeatableContent()) {
            values.put("unitLength", subfield.getUnitLength());
        }
        if (generator != null) {
            values.put("solr", generator.forSubfield(subfield));
        }
        if (subfield.getCodes() != null) {
            codes = new LinkedHashMap();
            for (EncodedValue code : subfield.getCodes()) {
                codeMap = new LinkedHashMap<String, String>();
                codeMap.put("label", code.getLabel());
                codes.put(code.getCode(), codeMap);
            }
            values.put("codes", codes);
        }
        if (subfield.getHistoricalCodes() != null) {
            codes = new LinkedHashMap();
            for (EncodedValue code : subfield.getHistoricalCodes()) {
                codeMap = new LinkedHashMap();
                codeMap.put("label", code.getLabel());
                codes.put(code.getCode(), codeMap);
            }
            values.put("historical-codes", codes);
        }
        return values;
    }

    private void dataFieldToJson(Map fields, DataFieldDefinition tag) {
        Object versionSpecificSubfields;
        DataFieldKeyGenerator keyGenerator = new DataFieldKeyGenerator(tag, this.parameters.getSolrFieldType());
        LinkedHashMap<String, Object> tagMap = new LinkedHashMap<String, Object>();
        tagMap.put("tag", tag.getTag());
        tagMap.put("label", tag.getLabel());
        tagMap.put("url", tag.getDescriptionUrl());
        tagMap.put("repeatable", this.resolveCardinality(tag.getCardinality()));
        if (this.exportSelfDescriptiveCodes) {
            tagMap.put("solr", keyGenerator.getIndexTag());
        }
        if (this.parameters.doExportFrbrFunctions()) {
            this.extractFunctions(tagMap, tag.getFrbrFunctions());
        }
        if (this.parameters.doExportCompilanceLevel()) {
            this.extractCompilanceLevel(tagMap, tag.getNationalCompilanceLevel(), tag.getMinimalCompilanceLevel());
        }
        if (this.parameters.isWithLocallyDefinedFields()) {
            tagMap.put("version", tag.getMarcVersion().getCode());
        }
        tagMap.put("indicator1", MappingToJson.indicatorToJson(tag.getInd1()));
        tagMap.put("indicator2", MappingToJson.indicatorToJson(tag.getInd2()));
        LinkedHashMap<String, Map<String, Object>> subfields = new LinkedHashMap<String, Map<String, Object>>();
        if (tag.getSubfields() != null) {
            for (SubfieldDefinition subfield : tag.getSubfields()) {
                subfields.put(subfield.getCode(), this.subfieldToJson(subfield, keyGenerator));
            }
        } else {
            logger.info(tag + " does not have subfields");
        }
        tagMap.put("subfields", subfields);
        if (this.parameters.isWithLocallyDefinedFields() && (versionSpecificSubfields = tag.getVersionSpecificSubfields()) != null && !versionSpecificSubfields.isEmpty()) {
            LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>> versionSpecificSubfieldsMap = new LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>();
            for (Map.Entry entry : versionSpecificSubfields.entrySet()) {
                String version = ((MarcVersion)((Object)entry.getKey())).getCode();
                subfields = new LinkedHashMap();
                for (SubfieldDefinition subfield : (List)entry.getValue()) {
                    subfields.put(subfield.getCode(), this.subfieldToJson(subfield, keyGenerator));
                }
                versionSpecificSubfieldsMap.put(version, subfields);
            }
            if (!versionSpecificSubfieldsMap.isEmpty()) {
                tagMap.put("versionSpecificSubfields", versionSpecificSubfieldsMap);
            }
        }
        if (tag.getHistoricalSubfields() != null) {
            subfields = new LinkedHashMap();
            for (EncodedValue code : tag.getHistoricalSubfields()) {
                LinkedHashMap<String, String> labelMap = new LinkedHashMap<String, String>();
                labelMap.put("label", code.getLabel());
                subfields.put(code.getCode(), labelMap);
            }
            tagMap.put("historical-subfields", subfields);
        }
        if (fields.containsKey(tag.getTag())) {
            Object existing = fields.get(tag.getTag());
            List<LinkedHashMap<String, Object>> list = null;
            if (existing instanceof Map) {
                list = new ArrayList<Map>();
                list.add((LinkedHashMap<String, Object>)((Map)existing));
            } else if (existing instanceof List) {
                list = (List)existing;
            } else {
                System.err.println("a strange object: " + existing.getClass().getCanonicalName());
                list = new ArrayList();
            }
            list.add(tagMap);
            fields.put(tag.getTag(), list);
        } else {
            fields.put(tag.getTag(), tagMap);
        }
    }

    private void extractFunctions(Map<String, Object> tagMap, List<FRBRFunction> functions) {
        if (functions != null && !functions.isEmpty()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (FRBRFunction function : functions) {
                paths.add(function.getPath());
            }
            tagMap.put("frbr-functions", paths);
        }
    }

    private Map<String, Object> subfieldToJson(SubfieldDefinition subfield, DataFieldKeyGenerator keyGenerator) {
        LinkedHashMap<String, Object> codeMap = new LinkedHashMap<String, Object>();
        codeMap.put("label", subfield.getLabel());
        codeMap.put("repeatable", this.resolveCardinality(subfield.getCardinality()));
        if (this.exportSelfDescriptiveCodes) {
            codeMap.put("solr", keyGenerator.forSubfield(subfield));
        }
        if (subfield.getCodeList() != null && !subfield.getCodeList().getCodes().isEmpty()) {
            CodeList codeList = subfield.getCodeList();
            LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
            meta.put("name", codeList.getName());
            meta.put("url", codeList.getUrl());
            if (this.exportSubfieldCodes && !codeList.getName().equals("MARC Organization Codes") && subfield.getCodeList() != null) {
                LinkedHashMap codes = new LinkedHashMap();
                for (EncodedValue code : subfield.getCodeList().getCodes()) {
                    LinkedHashMap<String, String> codeListMap = new LinkedHashMap<String, String>();
                    codeListMap.put("label", code.getLabel());
                    codes.put(code.getCode(), codeListMap);
                }
                meta.put("codes", codes);
            }
            codeMap.put("codelist", meta);
        }
        if (this.parameters.doExportFrbrFunctions()) {
            this.extractFunctions(codeMap, subfield.getFrbrFunctions());
        }
        if (this.parameters.doExportCompilanceLevel()) {
            this.extractCompilanceLevel(codeMap, subfield.getNationalCompilanceLevel(), subfield.getMinimalCompilanceLevel());
        }
        return codeMap;
    }

    private void extractCompilanceLevel(Map<String, Object> codeMap, CompilanceLevel nationalCompilanceLevel, CompilanceLevel minimalCompilanceLevel) {
        LinkedHashMap<String, String> levels = new LinkedHashMap<String, String>();
        if (nationalCompilanceLevel != null) {
            levels.put("national", nationalCompilanceLevel.getLabel());
        }
        if (minimalCompilanceLevel != null) {
            levels.put("minimal", minimalCompilanceLevel.getLabel());
        }
        if (!levels.isEmpty()) {
            codeMap.put("compilance-level", levels);
        }
    }

    private static Map<String, Object> indicatorToJson(Indicator indicator) {
        LinkedHashMap<String, String> map;
        if (!indicator.exists()) {
            return null;
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("label", indicator.getLabel());
        LinkedHashMap codes = new LinkedHashMap();
        for (EncodedValue code : indicator.getCodes()) {
            map = new LinkedHashMap<String, String>();
            map.put("label", code.getLabel());
            codes.put(code.getCode(), map);
        }
        value.put("codes", codes);
        if (indicator.getHistoricalCodes() != null) {
            codes = new LinkedHashMap();
            for (EncodedValue code : indicator.getHistoricalCodes()) {
                map = new LinkedHashMap();
                map.put("label", code.getLabel());
                codes.put(code.getCode(), map);
            }
            value.put("historical-codes", codes);
        }
        return value;
    }

    private boolean resolveCardinality(Cardinality cardinality) {
        return cardinality.getCode().equals("R");
    }

    public static void main(String[] args) throws ParseException {
        MappingToJson mapping = new MappingToJson(args);
        mapping.build();
        System.out.println(mapping.toJson());
    }
}

