/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import org.apache.commons.cli.ParseException;

public class MarcToSolrParameters
extends CommonParameters {
    private String solrUrl = null;
    private boolean doCommit = false;
    private SolrFieldType solrFieldType = SolrFieldType.MARC;
    private boolean isOptionSet = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("s", "solrUrl", true, "the URL of Solr server");
            this.options.addOption("c", "doCommit", false, "send commits to Solr regularly");
            this.options.addOption("t", "solrFieldType", true, "type of Solr fields, could be one of 'marc-tags', 'human-readable', or 'mixed'");
            this.isOptionSet = true;
        }
    }

    public MarcToSolrParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("solrUrl")) {
            this.solrUrl = this.cmd.getOptionValue("solrUrl");
        }
        if (this.cmd.hasOption("doCommit")) {
            this.doCommit = true;
        }
        if (this.cmd.hasOption("solrFieldType")) {
            this.solrFieldType = SolrFieldType.byCode(this.cmd.getOptionValue("solrFieldType"));
        }
    }

    public String getSolrUrl() {
        return this.solrUrl;
    }

    public boolean doCommit() {
        return this.doCommit;
    }

    public SolrFieldType getSolrFieldType() {
        return this.solrFieldType;
    }
}

