/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.utils.IgnorableFields;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilter;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilterFactory;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordIgnorator;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordIgnoratorFactory;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.definition.DataSource;
import de.gwdg.metadataqa.marc.definition.MarcFormat;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.utils.alephseq.AlephseqLine;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

public class CommonParameters
implements Serializable {
    private static final long serialVersionUID = -4760615880678251867L;
    protected String[] args;
    public static final String DEFAULT_OUTPUT_DIR = ".";
    public static final MarcVersion DEFAULT_MARC_VERSION = MarcVersion.MARC21;
    protected MarcVersion marcVersion = DEFAULT_MARC_VERSION;
    protected MarcFormat marcFormat = MarcFormat.ISO;
    protected DataSource dataSource = DataSource.FILE;
    protected boolean doHelp;
    protected boolean doLog = true;
    protected int limit = -1;
    protected int offset = -1;
    protected String id = null;
    protected Leader.Type defaultRecordType = null;
    protected boolean fixAlephseq = false;
    protected boolean fixAlma = false;
    protected boolean fixKbr = false;
    protected boolean alephseq = false;
    protected boolean marcxml = false;
    protected boolean lineSeparated = false;
    protected boolean trimId = false;
    private String outputDir = ".";
    protected RecordIgnorator recordIgnorator;
    protected RecordFilter recordFilter;
    protected IgnorableFields ignorableFields = new IgnorableFields();
    protected InputStream stream = null;
    protected String defaultEncoding = null;
    protected Options options = new Options();
    protected static final CommandLineParser parser = new DefaultParser();
    protected CommandLine cmd;
    private boolean isOptionSet = false;
    private AlephseqLine.TYPE alephseqLineType;
    private String picaIdField = "003@$0";
    private String picaSubfieldSeparator = "$";
    private String picaSchemaFile;
    private String picaRecordTypeField = "002@$0";
    private SchemaType schemaType = SchemaType.MARC21;

    protected void setOptions() {
        if (!this.isOptionSet) {
            this.options.addOption("m", "marcVersion", true, "MARC version ('OCLC' or 'DNB')");
            this.options.addOption("h", "help", false, "display help");
            this.options.addOption("n", "nolog", false, "do not display log messages");
            this.options.addOption("l", "limit", true, "limit the number of records to process");
            this.options.addOption("o", "offset", true, "the first record to process");
            this.options.addOption("i", "id", true, "the MARC identifier (content of 001)");
            this.options.addOption("d", "defaultRecordType", true, "the default record type if the record's type is undetectable");
            this.options.addOption("q", "fixAlephseq", false, "fix the known issues of Alephseq format");
            this.options.addOption("X", "fixAlma", false, "fix the known issues of Alma format");
            this.options.addOption("R", "fixKbr", false, "fix the known issues of Alma format");
            this.options.addOption("p", "alephseq", false, "the source is in Alephseq format");
            this.options.addOption("x", "marcxml", false, "the source is in MARCXML format");
            this.options.addOption("y", "lineSeparated", false, "the source is in line separated MARC format");
            this.options.addOption("t", "outputDir", true, "output directory");
            this.options.addOption("r", "trimId", false, "remove spaces from the end of record IDs");
            this.options.addOption("z", "ignorableFields", true, "ignore fields from the analysis");
            this.options.addOption("v", "ignorableRecords", true, "ignore records from the analysis");
            this.options.addOption("f", "marcFormat", true, "MARC format (like 'ISO' or 'MARCXML')");
            this.options.addOption("s", "dataSource", true, "data source (file of stream)");
            this.options.addOption("g", "defaultEncoding", true, "default character encoding");
            this.options.addOption("A", "alephseqLineType", true, "Alephseq line type");
            this.options.addOption("B", "picaIdField", true, "PICA id field");
            this.options.addOption("D", "picaSubfieldSeparator", true, "PICA subfield separator");
            this.options.addOption("E", "picaSchemaFile", true, "Avram PICA schema file");
            this.options.addOption("F", "schemaType", true, "metadata schema type ('MARC21', 'UNIMARC', or 'PICA')");
            this.options.addOption("G", "picaRecordType", true, "picaRecordType");
            this.options.addOption("I", "allowableRecords", true, "allow records for the analysis");
            this.isOptionSet = true;
        }
    }

    public CommonParameters() {
    }

    public CommonParameters(String[] arguments) throws ParseException {
        this.cmd = parser.parse(this.getOptions(), arguments);
        this.readSchemaType();
        this.readMarcVersion();
        this.readMarcFormat();
        this.readDataSource();
        this.doHelp = this.cmd.hasOption("help");
        this.doLog = !this.cmd.hasOption("nolog");
        this.readLimit();
        this.readOffset();
        if (this.offset > -1 && this.limit > -1) {
            this.limit += this.offset;
        }
        this.readId();
        this.readDefaultRecordType();
        this.setAlephseq(this.cmd.hasOption("alephseq"));
        this.fixAlephseq = this.cmd.hasOption("fixAlephseq");
        this.fixAlma = this.cmd.hasOption("fixAlma");
        this.fixKbr = this.cmd.hasOption("fixKbr");
        this.setMarcxml(this.cmd.hasOption("marcxml"));
        this.lineSeparated = this.cmd.hasOption("lineSeparated");
        this.readOutputDir();
        this.trimId = this.cmd.hasOption("trimId");
        this.readIgnorableFields();
        this.readIgnorableRecords();
        this.readAllowableRecords();
        this.readDefaultEncoding();
        this.readAlephseqLineType();
        this.readPicaIdField();
        this.readPicaSubfieldSeparator();
        this.readPicaSchemaFile();
        this.readPicaRecordType();
        this.args = this.cmd.getArgs();
    }

    private void readPicaSchemaFile() {
        if (this.cmd.hasOption("picaSchemaFile")) {
            this.picaSchemaFile = this.cmd.getOptionValue("picaSchemaFile");
        }
    }

    private void readPicaRecordType() {
        if (this.cmd.hasOption("picaRecordType")) {
            this.picaRecordTypeField = this.cmd.getOptionValue("picaRecordType");
        }
    }

    private void readPicaSubfieldSeparator() {
        if (this.cmd.hasOption("picaSubfieldSeparator")) {
            this.picaSubfieldSeparator = this.cmd.getOptionValue("picaSubfieldSeparator");
        }
    }

    private void readPicaIdField() {
        if (this.cmd.hasOption("picaIdField")) {
            this.picaIdField = this.cmd.getOptionValue("picaIdField");
        }
    }

    private void readAlephseqLineType() throws ParseException {
        if (this.cmd.hasOption("alephseqLineType")) {
            this.setAlephseqLineType(this.cmd.getOptionValue("alephseqLineType"));
        }
    }

    private void readDefaultEncoding() {
        if (this.cmd.hasOption("defaultEncoding")) {
            this.setDefaultEncoding(this.cmd.getOptionValue("defaultEncoding"));
        }
    }

    private void readIgnorableRecords() {
        String ignorableRecords = this.cmd.hasOption("ignorableRecords") ? this.cmd.getOptionValue("ignorableRecords") : "";
        this.setRecordIgnorator(ignorableRecords);
    }

    private void readAllowableRecords() {
        String allowableRecords = this.cmd.hasOption("allowableRecords") ? this.cmd.getOptionValue("allowableRecords") : "";
        this.setRecordFilter(allowableRecords);
    }

    private void readIgnorableFields() {
        if (this.cmd.hasOption("ignorableFields")) {
            this.setIgnorableFields(this.cmd.getOptionValue("ignorableFields"));
        }
    }

    private void readOutputDir() {
        if (this.cmd.hasOption("outputDir")) {
            this.outputDir = this.cmd.getOptionValue("outputDir");
        }
    }

    private void readDefaultRecordType() throws ParseException {
        if (this.cmd.hasOption("defaultRecordType")) {
            this.setDefaultRecordType(this.cmd.getOptionValue("defaultRecordType"));
        }
    }

    private void readId() {
        if (this.cmd.hasOption("id")) {
            this.id = this.cmd.getOptionValue("id").trim();
        }
    }

    private void readOffset() {
        if (this.cmd.hasOption("offset")) {
            this.offset = Integer.parseInt(this.cmd.getOptionValue("offset"));
        }
    }

    private void readLimit() {
        if (this.cmd.hasOption("limit")) {
            this.limit = Integer.parseInt(this.cmd.getOptionValue("limit"));
        }
    }

    private void readDataSource() throws ParseException {
        if (this.cmd.hasOption("dataSource")) {
            this.setDataSource(this.cmd.getOptionValue("dataSource"));
        }
    }

    private void readSchemaType() throws ParseException {
        if (this.cmd.hasOption("schemaType")) {
            this.setSchemaType(this.cmd.getOptionValue("schemaType"));
        }
    }

    private void setSchemaType(String input) throws ParseException {
        try {
            this.schemaType = SchemaType.valueOf(input);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(String.format("Unrecognized schemaType parameter value: '%s'", input));
        }
    }

    private void readMarcFormat() throws ParseException {
        if (this.cmd.hasOption("marcFormat")) {
            this.setMarcFormat(this.cmd.getOptionValue("marcFormat"));
        }
    }

    private void readMarcVersion() throws ParseException {
        if (this.cmd.hasOption("marcVersion")) {
            this.setMarcVersion(this.cmd.getOptionValue("marcVersion"));
        }
    }

    private void setAlephseqLineType(String alephseqLineTypeInput) throws ParseException {
        try {
            this.alephseqLineType = AlephseqLine.TYPE.valueOf(this.cmd.getOptionValue("alephseqLineType"));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(String.format("Unrecognized alephseqLineType parameter value: '%s'", alephseqLineTypeInput));
        }
    }

    public Options getOptions() {
        if (!this.isOptionSet) {
            this.setOptions();
        }
        return this.options;
    }

    public MarcVersion getMarcVersion() {
        return this.marcVersion;
    }

    public void setMarcVersion(MarcVersion marcVersion) {
        this.marcVersion = marcVersion;
    }

    public void setMarcVersion(String marcVersion) throws ParseException {
        this.marcVersion = MarcVersion.byCode(marcVersion.trim());
        if (this.marcVersion == null) {
            throw new ParseException(String.format("Unrecognized marcVersion parameter value: '%s'", marcVersion));
        }
    }

    public MarcFormat getMarcFormat() {
        return this.marcFormat;
    }

    public void setMarcFormat(MarcFormat marcFormat) {
        this.marcFormat = marcFormat;
    }

    public void setMarcFormat(String marcFormatString) throws ParseException {
        this.marcFormat = MarcFormat.byCode(marcFormatString.trim());
        if (this.marcFormat == null) {
            throw new ParseException(String.format("Unrecognized marcFormat parameter value: '%s'", marcFormatString));
        }
        if (this.marcFormat.equals((Object)MarcFormat.ALEPHSEQ)) {
            this.setAlephseq(true);
        }
        if (this.marcFormat.equals((Object)MarcFormat.XML)) {
            this.setMarcxml(true);
        }
        if (this.marcFormat.equals((Object)MarcFormat.LINE_SEPARATED)) {
            this.setLineSeparated(true);
        }
        if (this.marcFormat.equals((Object)MarcFormat.PICA_NORMALIZED) || this.marcFormat.equals((Object)MarcFormat.PICA_PLAIN)) {
            this.schemaType = SchemaType.PICA;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(String dataSourceString) throws ParseException {
        this.dataSource = DataSource.byCode(dataSourceString.trim());
        if (this.dataSource == null) {
            throw new ParseException(String.format("Unrecognized marcFormat parameter value: '%s'", dataSourceString));
        }
    }

    public boolean doHelp() {
        return this.doHelp;
    }

    public void setDoHelp(boolean doHelp) {
        this.doHelp = doHelp;
    }

    public boolean doLog() {
        return this.doLog;
    }

    public void setDoLog(boolean doLog) {
        this.doLog = doLog;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean hasId() {
        return StringUtils.isNotBlank((CharSequence)this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Leader.Type getDefaultRecordType() {
        return this.defaultRecordType;
    }

    public void setDefaultRecordType(Leader.Type defaultRecordType) {
        this.defaultRecordType = defaultRecordType;
    }

    public void setDefaultRecordType(String defaultRecordType) throws ParseException {
        this.defaultRecordType = Leader.Type.valueOf(defaultRecordType);
        if (this.defaultRecordType == null) {
            throw new ParseException(String.format("Unrecognized defaultRecordType parameter value: '%s'", defaultRecordType));
        }
    }

    public boolean fixAlephseq() {
        return this.fixAlephseq;
    }

    public void setFixAlephseq(boolean fixAlephseq) {
        this.fixAlephseq = fixAlephseq;
    }

    public boolean fixAlma() {
        return this.fixAlma;
    }

    public void setFixAlma(boolean fixAlma) {
        this.fixAlma = fixAlma;
    }

    public boolean fixKbr() {
        return this.fixKbr;
    }

    public void setFixKbr(boolean fixKbr) {
        this.fixKbr = fixKbr;
    }

    public String getReplecementInControlFields() {
        if (this.fixAlephseq()) {
            return "^";
        }
        if (this.fixAlma() || this.fixKbr()) {
            return "#";
        }
        return null;
    }

    public boolean isAlephseq() {
        return this.alephseq;
    }

    public void setAlephseq(boolean alephseq) {
        this.alephseq = alephseq;
        if (alephseq) {
            this.marcFormat = MarcFormat.ALEPHSEQ;
        }
    }

    public boolean isMarcxml() {
        return this.marcxml;
    }

    public void setMarcxml(boolean marcxml) {
        this.marcxml = marcxml;
        if (marcxml) {
            this.marcFormat = MarcFormat.XML;
        }
    }

    public boolean isLineSeparated() {
        return this.lineSeparated;
    }

    public void setLineSeparated(boolean lineSeparated) {
        this.lineSeparated = lineSeparated;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public boolean getTrimId() {
        return this.trimId;
    }

    public void setTrimId(boolean trimId) {
        this.trimId = trimId;
    }

    public IgnorableFields getIgnorableFields() {
        return this.ignorableFields;
    }

    public void setIgnorableFields(String ignorableFields) {
        this.ignorableFields.parseFields(ignorableFields.trim());
    }

    public RecordIgnorator getRecordIgnorator() {
        return this.recordIgnorator;
    }

    public void setRecordIgnorator(String ignorableRecords) {
        this.recordIgnorator = RecordIgnoratorFactory.create(this.schemaType, ignorableRecords.trim());
    }

    public RecordFilter getRecordFilter() {
        return this.recordFilter;
    }

    public void setRecordFilter(String allowableRecords) {
        this.recordFilter = RecordFilterFactory.create(this.schemaType, allowableRecords.trim());
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public AlephseqLine.TYPE getAlephseqLineType() {
        return this.alephseqLineType;
    }

    public String getPicaIdField() {
        return this.picaIdField;
    }

    public void setPicaIdField(String picaIdField) {
        this.picaIdField = picaIdField;
    }

    public String getPicaSubfieldSeparator() {
        return this.picaSubfieldSeparator;
    }

    public void setPicaSubfieldSeparator(String picaSubfieldSeparator) {
        this.picaSubfieldSeparator = picaSubfieldSeparator;
    }

    public String getPicaSchemaFile() {
        return this.picaSchemaFile;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public String getPicaRecordTypeField() {
        return this.picaRecordTypeField;
    }

    public boolean isMarc21() {
        return this.schemaType.equals((Object)SchemaType.MARC21);
    }

    public boolean isPica() {
        return this.schemaType.equals((Object)SchemaType.PICA);
    }

    public String formatParameters() {
        Object text = "";
        text = (String)text + String.format("schemaType: %s%n", new Object[]{this.schemaType});
        text = (String)text + String.format("marcVersion: %s, %s%n", this.marcVersion.getCode(), this.marcVersion.getLabel());
        text = (String)text + String.format("marcFormat: %s, %s%n", this.marcFormat.getCode(), this.marcFormat.getLabel());
        text = (String)text + String.format("dataSource: %s, %s%n", this.dataSource.getCode(), this.dataSource.getLabel());
        text = (String)text + String.format("limit: %d%n", this.limit);
        text = (String)text + String.format("offset: %s%n", this.offset);
        text = (String)text + String.format("MARC files: %s%n", StringUtils.join((Object[])this.args, (String)", "));
        text = (String)text + String.format("id: %s%n", this.id);
        text = (String)text + String.format("defaultRecordType: %s%n", new Object[]{this.defaultRecordType});
        text = (String)text + String.format("fixAlephseq: %s%n", this.fixAlephseq);
        text = (String)text + String.format("fixAlma: %s%n", this.fixAlma);
        text = (String)text + String.format("alephseq: %s%n", this.alephseq);
        text = (String)text + String.format("marcxml: %s%n", this.marcxml);
        text = (String)text + String.format("lineSeparated: %s%n", this.lineSeparated);
        text = (String)text + String.format("outputDir: %s%n", this.outputDir);
        text = (String)text + String.format("trimId: %s%n", this.trimId);
        text = (String)text + String.format("ignorableFields: %s%n", this.ignorableFields);
        text = (String)text + String.format("allowableRecords: %s%n", this.recordFilter);
        text = (String)text + String.format("ignorableRecords: %s%n", this.recordIgnorator);
        text = (String)text + String.format("defaultEncoding: %s%n", this.defaultEncoding);
        text = (String)text + String.format("alephseqLineType: %s%n", new Object[]{this.alephseqLineType});
        if (this.isPica()) {
            text = (String)text + String.format("picaIdField: %s%n", this.picaIdField);
            text = (String)text + String.format("picaSubfieldSeparator: %s%n", this.picaSubfieldSeparator);
            text = (String)text + String.format("picaRecordType: %s%n", this.picaRecordTypeField);
        }
        return text;
    }
}

