/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.analysis.DataElementCounter;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class DataElements
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(DataElements.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    private final Options options;
    private CompletenessParameters parameters;
    private Map<String, Integer> library003Counter = new TreeMap<String, Integer>();
    private Map<String, Integer> libraryCounter = new TreeMap<String, Integer>();
    private Map<String, Map<String, Integer>> packageCounter = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> elementCardinality = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> elementFrequency = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<Integer, Integer>> fieldHistogram = new HashMap<String, Map<Integer, Integer>>();
    private boolean readyToProcess;
    private DataElementCounter dataElementCounter;
    private File outputFile;

    public DataElements(String[] args) throws ParseException {
        this.parameters = new CompletenessParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) {
        DataElements processor = null;
        try {
            processor = new DataElements(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) throws IOException {
        if (this.parameters.getRecordIgnorator().isIgnorable(marcRecord)) {
            return;
        }
        this.printToFile(this.outputFile, StringUtils.join(this.dataElementCounter.count(marcRecord), (String)",") + "\n");
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.elementCardinality.put("all", new TreeMap());
        this.elementFrequency.put("all", new TreeMap());
        this.packageCounter.put("all", new TreeMap());
        this.dataElementCounter = new DataElementCounter(this.parameters.getOutputDir(), "top-fields.txt", DataElementCounter.Basis.EXISTENCE);
        this.outputFile = new File(this.parameters.getOutputDir(), "record-patterns.csv");
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        this.printToFile(this.outputFile, this.dataElementCounter.getHeader() + "\n");
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
    }

    private void printToFile(File file, String message) {
        block2: {
            try {
                FileUtils.writeStringToFile((File)file, (String)message, (Charset)Charset.defaultCharset(), (boolean)true);
            }
            catch (IOException e) {
                if (!this.parameters.doLog()) break block2;
                logger.log(Level.SEVERE, "printToFile", e);
            }
        }
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

