/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.plugin.CompletenessFactory;
import de.gwdg.metadataqa.marc.cli.plugin.CompletenessPlugin;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordFilter;
import de.gwdg.metadataqa.marc.cli.utils.ignorablerecords.RecordIgnorator;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.tags.TagCategory;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.utils.BasicStatistics;
import de.gwdg.metadataqa.marc.utils.TagHierarchy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class Completeness
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(Completeness.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    private static final Pattern numericalPattern = Pattern.compile("^(\\d)$");
    private final Options options;
    private CompletenessParameters parameters;
    private Map<String, Integer> library003Counter = new TreeMap<String, Integer>();
    private Map<String, Integer> libraryCounter = new TreeMap<String, Integer>();
    private Map<String, Map<String, Integer>> packageCounter = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> elementCardinality = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> elementFrequency = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<Integer, Integer>> fieldHistogram = new HashMap<String, Map<Integer, Integer>>();
    private boolean readyToProcess;
    private CompletenessPlugin plugin;
    private Map<DataFieldDefinition, String> packageNameCache = new HashMap<DataFieldDefinition, String>();
    private RecordFilter recordFilter;
    private RecordIgnorator recordIgnorator;

    public Completeness(String[] args) throws ParseException {
        this.parameters = new CompletenessParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
        this.plugin = CompletenessFactory.create(this.parameters);
        this.recordFilter = this.parameters.getRecordFilter();
        this.recordIgnorator = this.parameters.getRecordIgnorator();
    }

    public static void main(String[] args) {
        Completeness processor = null;
        try {
            processor = new Completeness(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) throws IOException {
        if (!this.recordFilter.isAllowable(marcRecord)) {
            return;
        }
        if (this.recordIgnorator.isIgnorable(marcRecord)) {
            return;
        }
        TreeMap<String, Integer> recordFrequency = new TreeMap<String, Integer>();
        TreeMap<String, Integer> recordPackageCounter = new TreeMap<String, Integer>();
        String documentType = this.plugin.getDocumentType(marcRecord);
        this.elementCardinality.computeIfAbsent(documentType, s -> new TreeMap());
        this.elementFrequency.computeIfAbsent(documentType, s -> new TreeMap());
        if (marcRecord.getControl003() != null) {
            this.count(marcRecord.getControl003().getContent(), this.library003Counter);
        }
        for (String library : this.extract(marcRecord, "852", "a")) {
            this.count(library, this.libraryCounter);
        }
        if (!this.parameters.isPica()) {
            this.processLeader(marcRecord, recordFrequency, recordPackageCounter, documentType);
            this.processSimpleControlfields(marcRecord, recordFrequency, recordPackageCounter, documentType);
            this.processPositionalControlFields(marcRecord, recordFrequency, recordPackageCounter, documentType);
        }
        this.processDataFields(marcRecord, recordFrequency, recordPackageCounter, documentType);
        for (String key : recordFrequency.keySet()) {
            this.count(key, this.elementFrequency.get(documentType));
            this.count(key, this.elementFrequency.get("all"));
            this.fieldHistogram.computeIfAbsent(key, s -> new TreeMap());
            this.count((Integer)recordFrequency.get(key), this.fieldHistogram.get(key));
        }
        for (String key : recordPackageCounter.keySet()) {
            this.packageCounter.computeIfAbsent(documentType, s -> new TreeMap());
            this.count(key, this.packageCounter.get(documentType));
            this.count(key, this.packageCounter.get("all"));
        }
    }

    private void processLeader(BibliographicRecord marcRecord, Map<String, Integer> recordFrequency, Map<String, Integer> recordPackageCounter, String documentType) {
        if (marcRecord.getLeader() != null) {
            for (ControlValue position : marcRecord.getLeader().getValuesList()) {
                String marcPath = position.getDefinition().getId();
                this.count(marcPath, this.elementCardinality.get(documentType));
                this.count(marcPath, this.elementCardinality.get("all"));
                this.count(marcPath, recordFrequency);
                this.count(TagCategory.TAGS_00X.getPackageName(), recordPackageCounter);
            }
        }
    }

    private void processSimpleControlfields(BibliographicRecord marcRecord, Map<String, Integer> recordFrequency, Map<String, Integer> recordPackageCounter, String documentType) {
        for (MarcControlField field : marcRecord.getSimpleControlfields()) {
            if (field == null) continue;
            String marcPath = field.getDefinition().getTag();
            this.count(marcPath, this.elementCardinality.get(documentType));
            this.count(marcPath, this.elementCardinality.get("all"));
            this.count(marcPath, recordFrequency);
            this.count(TagCategory.TAGS_00X.getPackageName(), recordPackageCounter);
        }
    }

    private void processPositionalControlFields(BibliographicRecord marcRecord, Map<String, Integer> recordFrequency, Map<String, Integer> recordPackageCounter, String documentType) {
        for (MarcPositionalControlField field : marcRecord.getPositionalControlfields()) {
            if (field == null) continue;
            for (ControlValue position : field.getValuesList()) {
                String marcPath = position.getDefinition().getId();
                this.count(marcPath, this.elementCardinality.get(documentType));
                this.count(marcPath, this.elementCardinality.get("all"));
                this.count(marcPath, recordFrequency);
                this.count(TagCategory.TAGS_00X.getPackageName(), recordPackageCounter);
            }
        }
    }

    private void processDataFields(BibliographicRecord marcRecord, Map<String, Integer> recordFrequency, Map<String, Integer> recordPackageCounter, String documentType) {
        for (DataField field : marcRecord.getDatafields()) {
            if (this.parameters.getIgnorableFields().contains(field.getTag())) continue;
            this.count(this.getPackageName(field), recordPackageCounter);
            this.count(field.getTag(), this.elementCardinality.get(documentType));
            this.count(field.getTag(), this.elementCardinality.get("all"));
            this.count(field.getTag(), recordFrequency);
            List<String> marcPaths = this.getMarcPaths(field);
            for (String marcPath : marcPaths) {
                this.count(marcPath, this.elementCardinality.get(documentType));
                this.count(marcPath, this.elementCardinality.get("all"));
                this.count(marcPath, recordFrequency);
            }
        }
    }

    private List<String> getMarcPaths(DataField field) {
        ArrayList<String> marcPaths = new ArrayList<String>();
        if (this.parameters.isMarc21()) {
            if (field.getInd1() != null && (field.getDefinition() != null && field.getDefinition().getInd1().exists() || !field.getInd1().equals(" "))) {
                marcPaths.add(String.format("%s$!ind1", field.getTag()));
            }
            if (field.getInd2() != null && (field.getDefinition() != null && field.getDefinition().getInd2().exists() || !field.getInd2().equals(" "))) {
                marcPaths.add(String.format("%s$!ind2", field.getTag()));
            }
        }
        for (MarcSubfield subfield : field.getSubfields()) {
            if (numericalPattern.matcher(subfield.getCode()).matches()) {
                marcPaths.add(String.format("%s$|%s", field.getTag(), subfield.getCode()));
                continue;
            }
            marcPaths.add(String.format("%s$%s", field.getTag(), subfield.getCode()));
        }
        return marcPaths;
    }

    private String getPackageName(DataField field) {
        String packageName;
        if (field.getDefinition() != null) {
            if (this.packageNameCache.containsKey(field.getDefinition())) {
                packageName = this.packageNameCache.get(field.getDefinition());
            } else {
                packageName = this.plugin.getPackageName(field);
                if (StringUtils.isBlank((CharSequence)packageName)) {
                    logger.warning(String.format("%s has no package. /%s", field, field.getDefinition().getClass()));
                    packageName = TagCategory.OTHER.getPackageName();
                }
                this.packageNameCache.put(field.getDefinition(), packageName);
            }
        } else {
            packageName = TagCategory.OTHER.getPackageName();
        }
        return packageName;
    }

    private List<String> extract(BibliographicRecord marcRecord, String tag, String subfield) {
        ArrayList<String> values = new ArrayList<String>();
        List<DataField> fields = marcRecord.getDatafield(tag);
        if (fields != null && !fields.isEmpty()) {
            for (DataField field : fields) {
                List<MarcSubfield> subfieldInstances = field.getSubfield(subfield);
                if (subfieldInstances == null) continue;
                for (MarcSubfield subfieldInstance : subfieldInstances) {
                    values.add(subfieldInstance.getValue());
                }
            }
        }
        return values;
    }

    private <T> void count(T key, Map<T, Integer> counter) {
        counter.computeIfAbsent(key, s -> 0);
        counter.put(key, counter.get(key) + 1);
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.elementCardinality.put("all", new TreeMap());
        this.elementFrequency.put("all", new TreeMap());
        this.packageCounter.put("all", new TreeMap());
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        String fileExtension = ".csv";
        char separator = this.getSeparator(this.parameters.getFormat());
        if (this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            fileExtension = ".tsv";
        }
        this.saveLibraries003(fileExtension, separator);
        this.saveLibraries(fileExtension, separator);
        this.savePackages(fileExtension, separator);
        this.saveMarcElements(fileExtension, separator);
    }

    private void saveLibraries003(String fileExtension, char separator) {
        logger.info("Saving Libraries003 file");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries003" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("library" + separator + "count\n");
            this.library003Counter.entrySet().stream().forEach(entry -> {
                try {
                    writer.write(String.format("\"%s\"%s%d%n", entry.getKey(), Character.valueOf(separator), entry.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveLibraries003", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveLibraries003", e);
        }
    }

    private void saveMarcElements(String fileExtension, char separator) {
        System.err.println("MARC elements");
        Path path = Paths.get(this.parameters.getOutputDir(), "marc-elements" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("documenttype", "path", "packageid", "package", "tag", "subfield", "number-of-record", "number-of-instances", "min", "max", "mean", "stddev", "histogram"));
            this.elementCardinality.keySet().stream().forEach(documentType -> this.elementCardinality.get(documentType).entrySet().stream().forEach(entry -> {
                try {
                    String marcPath = (String)entry.getKey();
                    int cardinality = (Integer)entry.getValue();
                    writer.write(this.formatCardinality(separator, marcPath, cardinality, (String)documentType));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveMarcElements", e);
                }
            }));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveMarcElements", e);
        }
    }

    private void savePackages(String fileExtension, char separator) {
        logger.info("saving Packages...");
        Path path = Paths.get(this.parameters.getOutputDir(), "packages" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow(Character.valueOf(separator), "documenttype", "packageid", "name", "label", "iscoretag", "count"));
            this.packageCounter.forEach((documentType, packages) -> packages.forEach((packageName, count) -> {
                try {
                    TagCategory tagCategory = TagCategory.getPackage(packageName);
                    String range = packageName;
                    String label = "";
                    int id = 100;
                    boolean isPartOfMarcScore = false;
                    if (tagCategory != null) {
                        id = tagCategory.getId();
                        range = tagCategory.getRange();
                        label = tagCategory.getLabel();
                        isPartOfMarcScore = tagCategory.isPartOfMarcCore();
                    } else {
                        logger.severe(packageName + " has not been found in TagCategory");
                    }
                    writer.write(Utils.createRow(Character.valueOf(separator), Utils.quote(documentType), id, Utils.quote(range), Utils.quote(label), isPartOfMarcScore, count));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "savePackages", e);
                }
            }));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "savePackages", e);
        }
    }

    private void saveLibraries(String fileExtension, char separator) {
        logger.info("Saving Libraries");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("library" + separator + "count\n");
            this.libraryCounter.entrySet().stream().forEach(entry -> {
                try {
                    writer.write(String.format("\"%s\"%s%d%n", entry.getKey(), Character.valueOf(separator), entry.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "saveLibraries", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "saveLibraries", e);
        }
    }

    private String formatCardinality(char separator, String marcPath, int cardinality, String documentType) {
        if (marcPath.equals("")) {
            logger.severe("Empty key from " + marcPath);
        }
        String marcPathLabel = marcPath.replace("!ind", "ind").replaceAll("\\|(\\d)$", "$1");
        int packageId = TagCategory.OTHER.getId();
        String packageLabel = TagCategory.OTHER.getLabel();
        String tagLabel = "";
        String subfieldLabel = "";
        TagHierarchy tagHierarchy = this.plugin.getTagHierarchy(marcPathLabel);
        if (tagHierarchy != null) {
            packageId = tagHierarchy.getPackageId();
            packageLabel = tagHierarchy.getPackageLabel();
            tagLabel = tagHierarchy.getTagLabel();
            subfieldLabel = tagHierarchy.getSubfieldLabel();
        } else {
            logger.severe("Key can not be found in the TagHierarchy: " + marcPathLabel);
        }
        Integer frequency = this.elementFrequency.get(documentType).get(marcPath);
        BasicStatistics statistics = new BasicStatistics(this.fieldHistogram.get(marcPath));
        if (!this.fieldHistogram.containsKey(marcPath)) {
            logger.warning(String.format("Field %s is not registered in histogram", marcPath));
        }
        List<Object> values = Utils.quote(Arrays.asList(documentType, marcPathLabel, packageId, packageLabel, tagLabel, subfieldLabel, frequency, cardinality, statistics.getMin(), statistics.getMax(), statistics.getMean(), statistics.getStdDev(), statistics.formatHistogram()));
        return StringUtils.join(values, (char)separator) + "\n";
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

