/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.ClassificationAnalyzer;
import de.gwdg.metadataqa.marc.analysis.ClassificationStatistics;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.ValidatorParameters;
import de.gwdg.metadataqa.marc.cli.processor.BibliographicInputProcessor;
import de.gwdg.metadataqa.marc.cli.utils.Collocation;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.cli.utils.Schema;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class ClassificationAnalysis
implements BibliographicInputProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(ClassificationAnalysis.class.getCanonicalName());
    private final Options options;
    private CommonParameters parameters;
    private boolean readyToProcess;
    private static char separator = (char)44;
    private File collectorFile;
    ClassificationStatistics statistics = new ClassificationStatistics();

    public ClassificationAnalysis(String[] args) throws ParseException {
        this.parameters = new ValidatorParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
        Schema.reset();
    }

    public static void main(String[] args) {
        ClassificationAnalysis processor = null;
        try {
            processor = new ClassificationAnalysis(args);
        }
        catch (ParseException e) {
            System.err.println(Utils.createRow("ERROR. ", e.getLocalizedMessage()));
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(BibliographicRecord marcRecord, int recordNumber) throws IOException {
        if (this.parameters.getRecordIgnorator().isIgnorable(marcRecord)) {
            return;
        }
        ClassificationAnalyzer analyzer = new ClassificationAnalyzer(marcRecord, this.statistics);
        analyzer.process();
        Integer total1 = this.statistics.getHasClassifications().get(true);
        if (total1 == null) {
            total1 = 0;
        }
        Integer total = this.statistics.recordCountWithClassification();
        if (total1.intValue() != total.intValue()) {
            logger.severe(String.format("%s COUNT: total (%d) != schemasInRecord (%d)", marcRecord.getId(true), total1, total));
            this.readyToProcess = false;
        }
    }

    private void printToFile(File file, String message) {
        block2: {
            try {
                FileUtils.writeStringToFile((File)file, (String)message, (Charset)Charset.defaultCharset(), (boolean)true);
            }
            catch (IOException | NullPointerException e) {
                if (!this.parameters.doLog()) break block2;
                logger.log(Level.SEVERE, "printToFile", e);
            }
        }
    }

    private File prepareReportFile(String outputDir, String fileName) {
        File reportFile = new File(outputDir, fileName);
        if (reportFile.exists() && !reportFile.delete()) {
            logger.log(Level.SEVERE, "File {} hasn't been deleted", reportFile.getAbsolutePath());
        }
        return reportFile;
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.printClassificationsBySchema();
        this.printClassificationsByRecords();
        this.printClassificationsHistogram();
        this.printFrequencyExamples();
        this.printSchemaSubfieldsStatistics();
        this.printClassificationsCollocation();
    }

    private void printClassificationsCollocation() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-collocations.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Collocation.header());
            Integer total1 = this.statistics.getHasClassifications().get(true);
            if (total1 == null) {
                total1 = 0;
            }
            Integer total = this.statistics.recordCountWithClassification();
            logger.info("total: " + total);
            if (total1 != total) {
                logger.severe(String.format("total from hasClassifications (%d) != from collation (%d)", total1, total));
            }
            this.statistics.getCollocationHistogram().entrySet().stream().map(e -> new Collocation((List)e.getKey(), (Integer)e.getValue(), total)).sorted((e1, e2) -> e1.compareTo((Collocation)e2) * -1).forEach(entry -> this.printCollocation(writer, (Collocation)entry));
        }
        catch (IOException e3) {
            logger.log(Level.SEVERE, "printClassificationsCollocation", e3);
        }
    }

    private void printCollocation(BufferedWriter writer, Collocation entry) {
        try {
            writer.write(entry.formatRow());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printCollocation", e);
        }
    }

    private void printClassificationsBySchema() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-by-schema.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("id", "field", "location", "scheme", "abbreviation", "abbreviation4solr", "recordcount", "instancecount", "type"));
            this.statistics.getInstances().entrySet().stream().sorted((e1, e2) -> {
                int i = ((Schema)e1.getKey()).getField().compareTo(((Schema)e2.getKey()).getField());
                if (i != 0) {
                    return i;
                }
                i = ((Schema)e1.getKey()).getLocation().compareTo(((Schema)e2.getKey()).getLocation());
                if (i != 0) {
                    return i;
                }
                return ((Integer)e2.getValue()).compareTo((Integer)e1.getValue());
            }).forEach(entry -> this.printSingleClassificationBySchema(writer, (Map.Entry<Schema, Integer>)entry));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printClassificationsBySchema", e);
        }
    }

    private void printSingleClassificationBySchema(BufferedWriter writer, Map.Entry<Schema, Integer> entry) {
        Schema schema = entry.getKey();
        int instanceCount = entry.getValue();
        int recordCount = this.statistics.getRecords().get(schema);
        try {
            writer.write(Utils.createRow(schema.getId(), schema.getField(), schema.getLocation(), "\"" + schema.getSchema().replace("\"", "\"\"") + "\"", "\"" + schema.getAbbreviation().replace("\"", "\"\"") + "\"", Utils.solarize(schema.getAbbreviation()), recordCount, instanceCount, schema.getType() == null ? "UNKNOWN" : schema.getType()));
        }
        catch (IOException | NullPointerException ex) {
            logger.log(Level.SEVERE, "printClassificationsBySchema", ex);
            logger.severe(schema.toString());
        }
    }

    private void printClassificationsByRecords() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-by-records.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("records-with-classification", "count"));
            this.statistics.getHasClassifications().entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).forEach(e -> {
                try {
                    writer.write(Utils.createRow(((Boolean)e.getKey()).toString(), e.getValue()));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "printClassificationsByRecords", ex);
                }
            });
        }
        catch (IOException e3) {
            logger.log(Level.SEVERE, "printClassificationsByRecords", e3);
        }
    }

    private void printClassificationsHistogram() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-histogram.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("count", "frequency"));
            this.statistics.getSchemaHistogram().entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).forEach(entry -> {
                try {
                    writer.write(Utils.createRow(entry.getKey(), entry.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printClassificationsHistogram", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printClassificationsHistogram", e);
        }
    }

    private void printFrequencyExamples() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-frequency-examples.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("count", "id"));
            this.statistics.getFrequencyExamples().entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).forEach(entry -> {
                try {
                    writer.write(Utils.createRow(entry.getKey(), entry.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printFrequencyExamples", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printFrequencyExamples", e);
        }
    }

    private void printSchemaSubfieldsStatistics() {
        Path path = Paths.get(this.parameters.getOutputDir(), "classifications-by-schema-subfields.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            List<String> header = Arrays.asList("id", "subfields", "count");
            writer.write(Utils.createRow(header));
            this.statistics.getSubfields().entrySet().stream().sorted((e1, e2) -> ((Schema)e1.getKey()).getField().compareTo(((Schema)e2.getKey()).getField())).forEach(schemaEntry -> this.printSingleSchemaSubfieldsStatistics(writer, (Map.Entry<Schema, Map<List<String>, Integer>>)schemaEntry));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printSchemaSubfieldsStatistics", e);
        }
    }

    private void printSingleSchemaSubfieldsStatistics(BufferedWriter writer, Map.Entry<Schema, Map<List<String>, Integer>> schemaEntry) {
        Schema schema = schemaEntry.getKey();
        Map<List<String>, Integer> val = schemaEntry.getValue();
        val.entrySet().stream().sorted((count1, count2) -> ((Integer)count2.getValue()).compareTo((Integer)count1.getValue())).forEach(countEntry -> {
            List subfields = (List)countEntry.getKey();
            int count = (Integer)countEntry.getValue();
            try {
                writer.write(Utils.createRow(schema.getId(), StringUtils.join((Iterable)subfields, (char)';'), count));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "printSingleSchemaSubfieldsStatistics", ex);
            }
        });
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

