/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.validator;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.validator.AbstractValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ControlFieldValidator;
import de.gwdg.metadataqa.marc.analysis.validator.DataFieldValidator;
import de.gwdg.metadataqa.marc.analysis.validator.LeaderValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.general.validator.ClassificationReferenceValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Validator
extends AbstractValidator {
    private BibliographicRecord marcRecord;
    private static final Logger logger = Logger.getLogger(Validator.class.getCanonicalName());

    public Validator() {
        super(new ValidatorConfiguration());
    }

    public Validator(ValidatorConfiguration configuration) {
        super(configuration);
    }

    public boolean validate(BibliographicRecord marcRecord) {
        this.marcRecord = marcRecord;
        this.validationErrors = new ArrayList();
        boolean isValidRecord = true;
        if (!marcRecord.getSchemaType().equals((Object)SchemaType.PICA)) {
            isValidRecord = this.validateLeader(isValidRecord);
        }
        isValidRecord = this.validateUnhandledTags(isValidRecord);
        isValidRecord = this.validateControlfields(isValidRecord);
        isValidRecord = this.validateDatafields(isValidRecord);
        return this.validationErrors.isEmpty();
    }

    private boolean validateLeader(boolean isValidRecord) {
        LeaderValidator leaderValidator = new LeaderValidator(this.configuration);
        boolean isValidComponent = leaderValidator.validate(this.marcRecord.getLeader());
        if (!isValidComponent) {
            List<ValidationError> leaderErrors = leaderValidator.getValidationErrors();
            for (ValidationError leaderError : leaderErrors) {
                if (leaderError.getRecordId() != null) continue;
                leaderError.setRecordId(this.marcRecord.getId());
            }
            this.validationErrors.addAll(this.filterErrors(leaderErrors));
            isValidRecord = isValidComponent;
        }
        return isValidRecord;
    }

    private boolean validateUnhandledTags(boolean isValidRecord) {
        if (!this.marcRecord.getUnhandledTags().isEmpty()) {
            if (this.configuration.doSummary()) {
                for (String tag : this.marcRecord.getUnhandledTags()) {
                    if (this.marcRecord.isIgnorableField(tag, this.configuration.getIgnorableFields()) || this.isIgnorableType(ValidationErrorType.FIELD_UNDEFINED)) continue;
                    this.validationErrors.add(new ValidationError(this.marcRecord.getId(), tag, ValidationErrorType.FIELD_UNDEFINED, tag, null));
                }
            } else {
                LinkedHashMap tags = new LinkedHashMap();
                for (String tag : this.marcRecord.getUnhandledTags()) {
                    Utils.count(tag, tags);
                }
                ArrayList<String> unhandledTagsList = new ArrayList<String>();
                for (Map.Entry entry : tags.entrySet()) {
                    String tag = (String)entry.getKey();
                    if ((Integer)entry.getValue() == 1) {
                        unhandledTagsList.add(tag);
                        continue;
                    }
                    unhandledTagsList.add(String.format("%s (%d*)", tag, entry.getValue()));
                }
                for (String tag : unhandledTagsList) {
                    if (this.marcRecord.isIgnorableField(tag, this.configuration.getIgnorableFields()) || this.isIgnorableType(ValidationErrorType.FIELD_UNDEFINED)) continue;
                    this.validationErrors.add(new ValidationError(this.marcRecord.getId(), tag, ValidationErrorType.FIELD_UNDEFINED, tag, null));
                }
            }
            isValidRecord = false;
        }
        return isValidRecord;
    }

    private boolean validateControlfields(boolean isValidRecord) {
        ControlFieldValidator controlFieldValidator = new ControlFieldValidator(this.configuration);
        for (MarcControlField controlField : this.marcRecord.getControlfields()) {
            boolean isValidComponent;
            if (controlField == null || (isValidComponent = controlFieldValidator.validate(controlField))) continue;
            this.validationErrors.addAll(this.filterErrors(controlFieldValidator.getValidationErrors()));
            isValidRecord = isValidComponent;
        }
        return isValidRecord;
    }

    private boolean validateDatafields(boolean isValidRecord) {
        DataFieldValidator validator = new DataFieldValidator(this.configuration);
        HashMap repetitionCounter = new HashMap();
        for (DataField dataField : this.marcRecord.getDatafields()) {
            ValidatorResponse validatorResponse;
            if (dataField.getDefinition() == null || this.marcRecord.isIgnorableField(dataField.getTag(), this.configuration.getIgnorableFields())) continue;
            Utils.count(dataField.getDefinition(), repetitionCounter);
            if (!validator.validate(dataField)) {
                isValidRecord = false;
                this.validationErrors.addAll(this.filterErrors(validator.getValidationErrors()));
            }
            if ((validatorResponse = ClassificationReferenceValidator.validate(dataField)).isValid()) continue;
            this.validationErrors.addAll(this.filterErrors(validatorResponse.getValidationErrors()));
            isValidRecord = false;
        }
        if (!this.isIgnorableType(ValidationErrorType.FIELD_NONREPEATABLE)) {
            for (Map.Entry entry : repetitionCounter.entrySet()) {
                DataFieldDefinition fieldDefinition = (DataFieldDefinition)entry.getKey();
                Integer count = (Integer)entry.getValue();
                if (count <= 1 || !fieldDefinition.getCardinality().equals((Object)Cardinality.Nonrepeatable)) continue;
                this.validationErrors.add(new ValidationError(this.marcRecord.getId(), fieldDefinition.getTag(), ValidationErrorType.FIELD_NONREPEATABLE, String.format("there are %d instances", count), fieldDefinition.getDescriptionUrl()));
                isValidRecord = false;
            }
        }
        return isValidRecord;
    }
}

