/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.validator.AbstractValidator;
import de.gwdg.metadataqa.marc.analysis.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.analysis.validator.ValidatorConfiguration;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataFieldValidator
extends AbstractValidator {
    private ErrorsCollector errors;
    private DataField field;
    private DataFieldDefinition definition;

    public DataFieldValidator() {
        super(new ValidatorConfiguration());
    }

    public DataFieldValidator(ValidatorConfiguration configuration) {
        super(configuration);
    }

    public boolean validate(DataField field) {
        this.field = field;
        this.validationErrors = new ArrayList();
        this.errors = new ErrorsCollector();
        List<MarcSubfield> subfields = field.getSubfields();
        SubfieldValidator subfieldValidator = new SubfieldValidator(this.configuration);
        DataFieldDefinition referencerDefinition = null;
        List<MarcSubfield> linkedSubfields = null;
        boolean ambiguousLinkage = false;
        this.definition = field.getDefinition();
        if (TagDefinitionLoader.load(field.getDefinition().getTag(), this.configuration.getMarcVersion()) == null) {
            this.addError(ValidationErrorType.FIELD_UNDEFINED, "");
            return false;
        }
        if (field.getTag().equals("880")) {
            List<MarcSubfield> subfield6s = field.getSubfield("6");
            if (subfield6s == null) {
                this.addError(ValidationErrorType.FIELD_MISSING_REFERENCE_SUBFIELD, "$6");
            } else if (!subfield6s.isEmpty()) {
                if (subfield6s.size() != 1) {
                    this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_AMBIGUOUS_LINKAGE, "There are multiple $6");
                    ambiguousLinkage = true;
                } else {
                    MarcSubfield subfield6 = subfield6s.get(0);
                    Object var9_9 = null;
                    try {
                        String message;
                        Linkage linkage = LinkageParser.getInstance().create(subfield6.getValue());
                        if (linkage == null || linkage.getLinkingTag() == null) {
                            message = String.format("Unparseable reference: '%s'", subfield6.getValue());
                            this.addError(ValidationErrorType.RECORD_INVALID_LINKAGE, message);
                        } else {
                            referencerDefinition = this.definition;
                            this.definition = TagDefinitionLoader.load(linkage.getLinkingTag(), this.configuration.getMarcVersion());
                            if (this.definition == null) {
                                this.definition = referencerDefinition;
                                message = String.format("refers to field %s, which is not defined", linkage.getLinkingTag());
                                this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, message);
                            } else {
                                linkedSubfields = field.getSubfields();
                                ArrayList<MarcSubfield> alternativeSubfields = new ArrayList<MarcSubfield>();
                                for (MarcSubfield subfield : field.getSubfields()) {
                                    MarcSubfield alternativeSubfield = new MarcSubfield(this.definition.getSubfield(subfield.getCode()), subfield.getCode(), subfield.getValue());
                                    alternativeSubfield.setField(field);
                                    alternativeSubfield.setMarcRecord(field.getMarcRecord());
                                    alternativeSubfield.setLinkage(linkage);
                                    alternativeSubfield.setReferencePath(referencerDefinition.getTag());
                                    alternativeSubfields.add(alternativeSubfield);
                                }
                                subfields = alternativeSubfields;
                            }
                        }
                    }
                    catch (ParserException e) {
                        this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, e.getMessage());
                    }
                }
            }
        }
        if (field.getUnhandledSubfields() != null) {
            this.addError(ValidationErrorType.SUBFIELD_UNDEFINED, StringUtils.join(field.getUnhandledSubfields(), (String)", "));
        }
        if (field.getInd1() != null) {
            this.validateIndicator(this.definition.getInd1(), field.getInd1(), this.configuration.getMarcVersion(), referencerDefinition);
        }
        if (field.getInd2() != null) {
            this.validateIndicator(this.definition.getInd2(), field.getInd2(), this.configuration.getMarcVersion(), referencerDefinition);
        }
        if (!ambiguousLinkage) {
            HashMap counter = new HashMap();
            for (MarcSubfield marcSubfield : subfields) {
                if (marcSubfield.getDefinition() == null) {
                    if (this.definition.isVersionSpecificSubfields(this.configuration.getMarcVersion(), marcSubfield.getCode())) {
                        marcSubfield.setDefinition(this.definition.getVersionSpecificSubfield(this.configuration.getMarcVersion(), marcSubfield.getCode()));
                    } else {
                        this.addError(ValidationErrorType.SUBFIELD_UNDEFINED, marcSubfield.getCode());
                        continue;
                    }
                }
                Utils.count(marcSubfield.getDefinition(), counter);
                if (subfieldValidator.validate(marcSubfield)) continue;
                this.errors.addAll(subfieldValidator.getValidationErrors());
            }
            for (Map.Entry entry : counter.entrySet()) {
                SubfieldDefinition subfieldDefinition = (SubfieldDefinition)entry.getKey();
                Integer count = (Integer)entry.getValue();
                if (count <= 1 || !subfieldDefinition.getCardinality().equals((Object)Cardinality.Nonrepeatable)) continue;
                this.addError(subfieldDefinition, ValidationErrorType.SUBFIELD_NONREPEATABLE, String.format("there are %d instances", count));
            }
        }
        if (referencerDefinition != null) {
            this.definition = referencerDefinition;
        }
        if (linkedSubfields != null) {
            subfields = linkedSubfields;
        }
        this.validationErrors.addAll(this.errors.getErrors());
        return this.errors.isEmpty();
    }

    private boolean validateIndicator(Indicator indicatorDefinition, String value, MarcVersion marcVersion, DataFieldDefinition referencerDefinition) {
        String path = indicatorDefinition.getPath();
        if (referencerDefinition != null) {
            path = String.format("%s->%s", referencerDefinition.getTag(), path);
        }
        if (indicatorDefinition.exists()) {
            if (!indicatorDefinition.hasCode(value) && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
                if (indicatorDefinition.isHistoricalCode(value)) {
                    this.addError(path, ValidationErrorType.INDICATOR_OBSOLETE, value);
                } else {
                    this.addError(path, ValidationErrorType.INDICATOR_INVALID_VALUE, value);
                }
            }
        } else if (!value.equals(" ") && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
            this.addError(path, ValidationErrorType.INDICATOR_NON_EMPTY, value);
        }
        return this.errors.isEmpty();
    }

    private void addError(ValidationErrorType type, String message) {
        this.addError(this.definition.getTag(), type, message);
    }

    private void addError(SubfieldDefinition subfieldDefinition, ValidationErrorType type, String message) {
        this.addError(subfieldDefinition.getPath(), type, message);
    }

    private void addError(String path, ValidationErrorType type, String message) {
        if (!this.isIgnorableType(type)) {
            String id = this.field.getMarcRecord() == null ? null : this.field.getMarcRecord().getId();
            String url = this.definition.getDescriptionUrl();
            this.errors.add(id, path, type, message, url);
        }
    }
}

