/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis.bl;

import de.gwdg.metadataqa.marc.analysis.bl.Band;
import de.gwdg.metadataqa.marc.analysis.bl.Element;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum UseCase {
    B01(Band.BASIC, "FIND by the title or name of the entity described", "", "245$a", "Mandatory"),
    B02(Band.BASIC, "OBTAIN the item or access to the content using shelfmark or link", "See also README B02", "852;856", "Mandatory"),
    B03(Band.BASIC, "SELECT in accordance with restrictions on access or reuse", "See  README B03", "506;540", "Mandatory if applicable"),
    B04(Band.BASIC, "SELECT by content, media  or carrier type", "", "336;337;338", "Mandatory"),
    B05(Band.BASIC, "IDENTIFY or SELECT by attributes appropriate to the type of resource", "See specific tabs", "As specified", "Mandatory if applicable"),
    B06(Band.BASIC, "IDENTIFY the provenance of the item(s) described", "Copy specific policy applies", "541;561;700", "Mandatory if applicable"),
    B07(Band.BASIC, "FIND using a standard identifier ", "Monograph;Serial", "021;022", "Mandatory if applicable"),
    B08(Band.BASIC, "IDENTIFY of SELECT by source of metadata", "", "040", "Mandatory"),
    B09(Band.BASIC, "MANAGE by using the cataloguing template appropriate to the resource/workflow", "", "FMT", "Mandatory"),
    B10(Band.BASIC, "MANAGE routing to services", "Record is finished (FIN=Y); Digital: 859$a is valid", "FIN;859", "Mandatory if applicable"),
    B11(Band.BASIC, "MANAGE by date of publication (or coverage)", "", "008/6-14", "Mandatory"),
    B12(Band.BASIC, "MANAGE by country of publication", "", "008/15-17", "Mandatory"),
    B13(Band.BASIC, "MANAGE by language of content", "", "008/35-37", "Mandatory"),
    B14(Band.BASIC, "MANAGE by source of cataloguing", "", "040", "Mandatory"),
    B15(Band.BASIC, "FIND by National Bibliography number", "Valid for BNB", "015", "Mandatory if applicable"),
    S01(Band.SATISFACTORY, "IDENTIFY the intellectual content of the resource", "The Work or Expression manifested needs to be  disambiguated or explicitly identified", "130;1XX$t;240;730;7XX$t", "Mandatory if applicable"),
    S02(Band.SATISFACTORY, "IDENTIFY principle responsibility for the intellectual content of the resource", "Creator of the work is known", "1XX;7XX", "Mandatory if applicable"),
    S03(Band.SATISFACTORY, "IDENTIFY the subject of the Work", "The Work satisfies the criteria for assignment of subject terms according to the subject system(s) being applied", "052;055;072;080;084;085;086;6XX", "Mandatory if applicable"),
    S04(Band.SATISFACTORY, "IDENTIFY or SELECT by attributes appropriate to the type of resource", "See specific tabs", "As specified", "Mandatory if applicable"),
    S05(Band.SATISFACTORY, "IDENTIFY or SELECT by version or edition", "Edition statement or version", "250", "Mandatory if applicable"),
    S06(Band.SATISFACTORY, "IDENTIFY or SELECT by production, publication,  distribution or manufacture details", "Publication statement ", "264;260", "Mandatory if applicable"),
    S07(Band.SATISFACTORY, "FIND by variant titles", "Manifestation has or is known by variant titles", "246", "Mandatory if applicable"),
    S08(Band.SATISFACTORY, "SELECT by aggregated works", "Aggregate is of a type for which a contents note is required", "505", "Mandatory if applicable"),
    S09(Band.SATISFACTORY, "SELECT by extent", "Extent is complete", "300$a", "Mandatory if applicable"),
    S10(Band.SATISFACTORY, "MANAGE source of information", "Source is not title page or equivalent", "588", "Mandatory if applicable"),
    E01(Band.EFFECTIVE, "IDENTIFY Agents with responsibility for augmentations of a Work, for example translators, illustrators, performers, etc. ", "Responsibility for augmentation, etc. can be determined", "7XX", "Mandatory if applicable"),
    E02(Band.EFFECTIVE, "NAVIGATE to/from an Agent associated with the resource", "Valid relationship identifier/URI", "1XX$e;7XX$e", "Mandatory if applicable"),
    E03(Band.EFFECTIVE, "MANAGE collection by subject", "In scope for DDC", "082", "Mandatory if applicable"),
    E04(Band.EFFECTIVE, "IDENTIFY former owners/custodians of the item described", "Provenance is considered significant", "7XX", "Mandatory if applicable"),
    E05(Band.EFFECTIVE, "NAVIGATE to related Works, Expressions or Manifestations", "Derived works or expressions", "6XX;730;7XX$t;LKR", "Mandatory if applicable"),
    E06(Band.EFFECTIVE, "FIND aggregated Works", "Manifestation embodies more than one significant Expression", "700$t;710$t;730", "Mandatory if applicable");

    private Matcher alphaMatcher = Pattern.compile("^[A-Z]{3}$").matcher("");
    private Band band;
    private String useCase;
    private String condition;
    private String encoding;
    private List<String> dataElelemnts;
    private List<Element> elements = new ArrayList<Element>();
    private String status;

    private UseCase(Band band, String useCase, String condition, String encoding, String status) {
        this.band = band;
        this.useCase = useCase;
        this.condition = condition;
        this.encoding = encoding;
        this.status = status;
        this.createDataELements();
    }

    private void createDataELements() {
        this.dataElelemnts = Arrays.asList(this.encoding.split(";"));
        for (String element : this.dataElelemnts) {
            String[] parts = element.split("\\$", 2);
            String tag = parts[0];
            String subfield = parts.length > 1 ? parts[1] : null;
            List<DataFieldDefinition> candidates = TagDefinitionLoader.findPatterns(tag, MarcVersion.BL);
            if (!candidates.isEmpty()) {
                for (DataFieldDefinition definition : candidates) {
                    if (subfield != null && definition.getSubfield(subfield) == null) continue;
                    this.elements.add(new Element(definition.getTag(), definition, subfield));
                }
                continue;
            }
            if (!this.alphaMatcher.reset(tag).matches()) continue;
            this.elements.add(new Element(tag, null, subfield));
        }
    }

    public Band getBand() {
        return this.band;
    }

    public String getUseCase() {
        return this.useCase;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getStatus() {
        return this.status;
    }

    public List<String> getDataElelemnts() {
        return this.dataElelemnts;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<String> getDataElelemntsNormalized() {
        return this.elements.stream().map(e -> e.toString()).collect(Collectors.toList());
    }
}

