/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class DataElementCounter {
    private static final Logger logger = Logger.getLogger(DataElementCounter.class.getCanonicalName());
    List<DataElement> elements = new ArrayList<DataElement>();
    Map<String, List<DataElement>> tags = new LinkedHashMap<String, List<DataElement>>();
    private final String header;
    private final Basis basis;

    public DataElementCounter(String dir, String fileName, Basis basis) {
        this.basis = basis;
        File file = new File(dir, fileName);
        String _header = "";
        try {
            String[] topFields;
            List lines = FileUtils.readLines((File)file, (String)"utf-8");
            _header = (String)lines.get(0);
            for (String field : topFields = _header.split(",")) {
                String[] parts = field.split("\\$");
                DataElement element = new DataElement(parts[0], parts[1]);
                this.elements.add(element);
                this.tags.computeIfAbsent(element.field, s -> new ArrayList());
                this.tags.get(element.field).add(element);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.header = _header;
    }

    public List<Integer> count(BibliographicRecord marcRecord) {
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Map.Entry<String, List<DataElement>> entry : this.tags.entrySet()) {
            List<DataField> instances = marcRecord.getDatafield(entry.getKey());
            if (instances == null || instances.isEmpty()) {
                for (DataElement element : entry.getValue()) {
                    counts.add(0);
                }
                continue;
            }
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (DataField instance : instances) {
                for (DataElement element : entry.getValue()) {
                    result.computeIfAbsent(element.subfield, s -> 0);
                    List<MarcSubfield> subfields = instance.getSubfield(element.subfield);
                    if (subfields == null || subfields.isEmpty()) continue;
                    result.put(element.subfield, (Integer)result.get(element.subfield) + subfields.size());
                }
            }
            for (DataElement element : entry.getValue()) {
                int score = (Integer)result.get(element.subfield);
                if (this.basis.equals((Object)Basis.EXISTENCE) && score >= 1) {
                    score = 1;
                }
                counts.add(score);
            }
        }
        return counts;
    }

    public String getHeader() {
        return this.header;
    }

    class DataElement {
        String field;
        String subfield;
        String key;

        public DataElement(String field, String subfield) {
            this.field = field;
            this.subfield = subfield;
            this.key = field + "$" + subfield;
        }
    }

    public static enum Basis {
        EXISTENCE,
        OCCURENCE;

    }
}

