/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.Classifier;
import de.gwdg.metadataqa.marc.analysis.bl.Band;
import de.gwdg.metadataqa.marc.analysis.bl.Element;
import de.gwdg.metadataqa.marc.analysis.bl.UseCase;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BLClassifier
implements Classifier {
    private static final Logger logger = Logger.getLogger(BLClassifier.class.getCanonicalName());
    private List<UseCase> basicUseCases = new ArrayList<UseCase>();
    private List<UseCase> satisfactoryUseCases = new ArrayList<UseCase>();
    private List<UseCase> effectiveUseCases = new ArrayList<UseCase>();

    public BLClassifier() {
        for (UseCase useCase : UseCase.values()) {
            if (useCase.getBand().equals((Object)Band.BASIC)) {
                this.basicUseCases.add(useCase);
                continue;
            }
            if (useCase.getBand().equals((Object)Band.SATISFACTORY)) {
                this.satisfactoryUseCases.add(useCase);
                continue;
            }
            if (!useCase.getBand().equals((Object)Band.EFFECTIVE)) continue;
            this.effectiveUseCases.add(useCase);
        }
    }

    @Override
    public String classify(BibliographicRecord marcRecord) {
        String level = Band.DEFICIENT.name();
        for (UseCase useCase : this.basicUseCases) {
            if (!useCase.getStatus().equals("Mandatory") || useCase.getElements().isEmpty() || this.satisfy(marcRecord, useCase)) continue;
            return level;
        }
        level = Band.BASIC.name();
        for (UseCase useCase : this.satisfactoryUseCases) {
            if (useCase.getElements().isEmpty() || this.satisfy(marcRecord, useCase)) continue;
            return level;
        }
        level = Band.SATISFACTORY.name();
        for (UseCase useCase : this.effectiveUseCases) {
            if (useCase.getElements().isEmpty() || this.satisfy(marcRecord, useCase)) continue;
            return level;
        }
        level = Band.EFFECTIVE.name();
        return level;
    }

    private boolean satisfy(BibliographicRecord marcRecord, UseCase useCase) {
        for (Element element : useCase.getElements()) {
            if (!marcRecord.hasDatafield(element.getTag())) continue;
            if (element.getSubfield() == null) {
                return true;
            }
            for (DataField field : marcRecord.getDatafield(element.getTag())) {
                List<MarcSubfield> subfields = field.getSubfield(element.getSubfield());
                if (subfields == null || subfields.isEmpty()) continue;
                return true;
            }
        }
        logger.info(String.format("failed for %s (%s -- %s -- %s)", useCase.name(), useCase.getUseCase(), useCase.getEncoding(), useCase.getDataElelemntsNormalized()));
        return false;
    }
}

