/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    private Utils() {
    }

    public static List<EncodedValue> generateCodes(String ... input) {
        if (input.length % 2 != 0) {
            throw new IllegalArgumentException("Number of input should be even");
        }
        ArrayList<EncodedValue> codes = new ArrayList<EncodedValue>();
        int len = input.length;
        for (int i = 0; i < len; i += 2) {
            codes.add(new EncodedValue(input[i], input[i + 1]));
        }
        return codes;
    }

    public static List<ControlfieldPositionDefinition> generateControlPositionList(ControlfieldPositionDefinition ... input) {
        ArrayList<ControlfieldPositionDefinition> list = new ArrayList<ControlfieldPositionDefinition>();
        list.addAll(Arrays.asList(input));
        return list;
    }

    public static String extractPackageName(DataField field) {
        return Utils.extractPackageName(field.getDefinition());
    }

    public static String extractPackageName(DataFieldDefinition field) {
        return field.getClass().getPackage().getName().replace("de.gwdg.metadataqa.marc.definition.tags.", "").replace("de.gwdg.metadataqa.marc.utils.", "");
    }

    public static String extractPackageName(Class<? extends DataFieldDefinition> field) {
        return field.getPackage().getName().replace("de.gwdg.metadataqa.marc.definition.tags.", "").replace("de.gwdg.metadataqa.marc.utils.", "");
    }

    public static MarcVersion getVersion(DataFieldDefinition field) {
        return Utils.package2version(Utils.extractPackageName(field));
    }

    public static MarcVersion getVersion(Class<? extends DataFieldDefinition> field) {
        return Utils.package2version(Utils.extractPackageName(field));
    }

    public static MarcVersion package2version(String packageName) {
        MarcVersion version;
        switch (packageName) {
            case "bltags": {
                version = MarcVersion.BL;
                break;
            }
            case "dnbtags": {
                version = MarcVersion.DNB;
                break;
            }
            case "fennicatags": {
                version = MarcVersion.FENNICA;
                break;
            }
            case "genttags": {
                version = MarcVersion.GENT;
                break;
            }
            case "oclctags": {
                version = MarcVersion.OCLC;
                break;
            }
            case "sztetags": {
                version = MarcVersion.SZTE;
                break;
            }
            case "nkcrtags": {
                version = MarcVersion.NKCR;
                break;
            }
            case "uvatags": {
                version = MarcVersion.UVA;
                break;
            }
            case "b3kattags": {
                version = MarcVersion.B3KAT;
                break;
            }
            case "kbrtags": {
                version = MarcVersion.KBR;
                break;
            }
            default: {
                version = MarcVersion.MARC21;
            }
        }
        return version;
    }

    public static List<Object> quote(List<? extends Serializable> values) {
        ArrayList<Object> quoted = new ArrayList<Object>();
        for (Serializable serializable : values) {
            quoted.add(Utils.quote(serializable));
        }
        return quoted;
    }

    public static Object quote(Object value) {
        if (value instanceof String) {
            return "\"" + ((String)value).replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"";
        }
        return value;
    }

    public static <T> void count(T key, Map<T, Integer> counter) {
        counter.computeIfAbsent(key, s -> 0);
        counter.put(key, counter.get(key) + 1);
    }

    public static <T> void add(T key, Map<T, Integer> counter, int i) {
        counter.computeIfAbsent(key, s -> 0);
        counter.put(key, counter.get(key) + i);
    }

    public static <T> List<String> counterToList(Map<T, Integer> counter) {
        return Utils.counterToList(':', counter);
    }

    public static <T> List<String> counterToList(char separator, Map<T, Integer> counter) {
        ArrayList<String> items = new ArrayList<String>();
        for (Map.Entry<T, Integer> entry : counter.entrySet()) {
            items.add(String.format("%s%s%d", entry.getKey().toString(), Character.valueOf(separator), entry.getValue()));
        }
        return items;
    }

    public static String solarize(String abbreviation) {
        abbreviation = StringUtils.stripAccents((String)abbreviation);
        abbreviation = abbreviation.replaceAll("\\W", "_").toLowerCase();
        return abbreviation;
    }

    public static String createRow(Object ... fields) {
        char separator = ',';
        if (fields[0].getClass() == Character.class) {
            separator = ((Character)fields[0]).charValue();
            fields = Arrays.copyOfRange(fields, 1, fields.length);
        }
        return Utils.createRowWithSep(separator, fields);
    }

    public static String createRowWithSep(char separator, Object ... fields) {
        if (fields.length == 1 && fields[0] instanceof List) {
            return StringUtils.join((Iterable)((List)fields[0]), (char)separator) + "\n";
        }
        return StringUtils.join((Object[])fields, (char)separator) + "\n";
    }

    public static String base36Encode(String id) {
        return Integer.toString(Utils.parseId(id), 36);
    }

    public static int parseId(String id) {
        return id.contains("+") ? Utils.scientificNotationToInt(id) : Integer.parseInt(id);
    }

    public static String base36Encode(int i) {
        return Integer.toString(i, 36);
    }

    public static int scientificNotationToInt(String scientificNotation) {
        BigDecimal value = new BigDecimal(scientificNotation);
        return value.toBigInteger().intValue();
    }

    public static String substring(String value, int start, int end) {
        if (start < value.length()) {
            if (end <= value.length()) {
                return value.substring(start, end);
            }
            return value.substring(start);
        }
        throw new StringIndexOutOfBoundsException(String.format("Character position range %d-%d is not available in string '%s'", start, end, value));
    }

    public static Map<String, Boolean> listToMap(List<String> list) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (String tag : list) {
            map.put(tag, true);
        }
        return map;
    }

    public static String base64decode(String raw) {
        Base64.Decoder dec = Base64.getDecoder();
        String decoded = new String(dec.decode(raw.replaceAll("^base64:", "")));
        return decoded;
    }
}

