/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.record.BibliographicRecord;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MarcSubfield
implements Serializable {
    private static final Logger logger = Logger.getLogger(MarcSubfield.class.getCanonicalName());
    private BibliographicRecord marcRecord;
    private DataField field;
    private SubfieldDefinition definition;
    private final String code;
    private final String value;
    private String codeForIndex = null;
    private ErrorsCollector errors = null;
    private Linkage linkage;
    private String referencePath;
    private static Map<String, String> prefixCache;

    public MarcSubfield(SubfieldDefinition definition, String code, String value) {
        this.definition = definition;
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public DataField getField() {
        return this.field;
    }

    public void setField(DataField field) {
        this.field = field;
    }

    public Linkage getLinkage() {
        return this.linkage;
    }

    public void setLinkage(Linkage linkage) {
        this.linkage = linkage;
    }

    public String getReferencePath() {
        return this.referencePath;
    }

    public void setReferencePath(String referencePath) {
        this.referencePath = referencePath;
    }

    public String getLabel() {
        String label = this.code;
        if (this.definition != null && this.definition.getLabel() != null) {
            label = this.definition.getLabel();
        }
        return label;
    }

    public String resolve() {
        if (this.definition == null) {
            return this.value;
        }
        return this.definition.resolve(this.value);
    }

    public SubfieldDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(SubfieldDefinition definition) {
        this.definition = definition;
    }

    public BibliographicRecord getMarcRecord() {
        return this.marcRecord;
    }

    public void setMarcRecord(BibliographicRecord marcRecord) {
        this.marcRecord = marcRecord;
    }

    public String getCodeForIndex() {
        if (this.codeForIndex == null) {
            this.codeForIndex = "_" + this.code;
            if (this.definition != null && this.definition.getCodeForIndex() != null) {
                this.codeForIndex = this.definition.getCodeForIndex();
            }
        }
        return this.codeForIndex;
    }

    public Map<String, String> parseContent() {
        if (this.definition.hasContentParser()) {
            try {
                return this.definition.getContentParser().parse(this.value);
            }
            catch (ParserException e) {
                String msg = String.format("Error in record: '%s' %s$%s: '%s'. Error message: '%s'", this.marcRecord.getId(), this.field.getTag(), this.definition.getCode(), this.value, e.getMessage());
                logger.severe(msg);
            }
        }
        return null;
    }

    public Map<String, List<String>> getKeyValuePairs(DataFieldKeyGenerator keyGenerator) {
        String cacheKey;
        if (prefixCache == null) {
            prefixCache = new HashMap<String, String>();
        }
        if (!prefixCache.containsKey(cacheKey = String.format("%s$%s-%s-%s", new Object[]{this.getField().getTag(), this.code, keyGenerator.getType().getType(), keyGenerator.getMarcVersion()}))) {
            prefixCache.put(cacheKey, keyGenerator.forSubfield(this));
        }
        String prefix = prefixCache.get(cacheKey);
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        pairs.put(prefix, Collections.singletonList(this.resolve()));
        if (this.getDefinition() != null) {
            this.getKeyValuePairsForPositionalSubfields(pairs, prefix);
            this.getKeyValuePairsFromContentParser(keyGenerator, pairs);
        }
        return pairs;
    }

    private void getKeyValuePairsFromContentParser(DataFieldKeyGenerator keyGenerator, Map<String, List<String>> pairs) {
        Map<String, String> extra;
        if (this.getDefinition().hasContentParser() && (extra = this.parseContent()) != null) {
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                pairs.put(keyGenerator.forSubfield(this, entry.getKey()), Collections.singletonList(entry.getValue()));
            }
        }
    }

    private void getKeyValuePairsForPositionalSubfields(Map<String, List<String>> pairs, String prefix) {
        if (this.getDefinition().hasPositions()) {
            Map<String, String> extra = this.getDefinition().resolvePositional(this.getValue());
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                pairs.put(prefix + "_" + entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
    }

    public String toString() {
        return "MarcSubfield{code='" + this.code + "', value='" + this.value + "'}";
    }
}

