/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CsvUtils {
    public static String createCsv(List<? extends Serializable> values) {
        return CsvUtils.createCsv(CsvUtils.asArray(values));
    }

    public static String createCsv(String[] values) {
        String csv = null;
        try (StringWriter sw = new StringWriter();
             CSVWriter csvWriter = new CSVWriter((Writer)sw);){
            csvWriter.writeNext(CsvUtils.cleanRow(values), false);
            csv = sw.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return csv;
    }

    private static String[] asArray(List<? extends Serializable> values) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Serializable serializable : values) {
            if (serializable instanceof String) {
                strings.add((String)((Object)serializable));
                continue;
            }
            if (serializable == null) {
                strings.add("");
                continue;
            }
            strings.add(serializable.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static String[] cleanRow(String[] values) {
        ArrayList<Object> quoted = new ArrayList<Object>();
        for (String value : values) {
            quoted.add(CsvUtils.cleanCell(value));
        }
        return quoted.toArray(new String[quoted.size()]);
    }

    private static Object cleanCell(Object value) {
        if (value instanceof String) {
            return ((String)value).replace("\n", "\\n");
        }
        return value;
    }
}

