/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.bibliographic.BibliographicFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaplusTag;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PicaTagDefinition
implements BibliographicFieldDefinition {
    private static final Logger logger = Logger.getLogger(PicaTagDefinition.class.getCanonicalName());
    private static final Pattern rangePattern = Pattern.compile("^(\\d+)-(\\d+)$");
    private PicaplusTag tag;
    private final String pica3;
    private Boolean repeatable;
    private Cardinality cardinality;
    private Boolean hasSheet;
    private final String label;
    protected String descriptionUrl;
    protected List<SubfieldDefinition> subfields;

    public PicaTagDefinition(String pica3, String picaplus, boolean repeatable, boolean sheet, String label) {
        this.pica3 = pica3;
        this.repeatable = repeatable;
        this.cardinality = repeatable ? Cardinality.Repeatable : Cardinality.Nonrepeatable;
        this.hasSheet = sheet;
        this.label = label;
        this.tag = new PicaplusTag(picaplus);
    }

    public PicaTagDefinition(String[] input) {
        this.pica3 = input[0];
        this.tag = new PicaplusTag(input[1]);
        this.label = input[4];
        this.parseRepeatable(input[2]);
        this.parseSheet(input[3]);
    }

    public PicaplusTag getPicaplusTag() {
        return this.tag;
    }

    private void parseSheet(String input) {
        switch (input) {
            case "": 
            case "-": {
                this.hasSheet = false;
                break;
            }
            case "+": {
                this.hasSheet = true;
                break;
            }
            default: {
                logger.severe(String.format("unhandled 'hasSheet' value: %s (%s)", input, this.tag.getRaw()));
            }
        }
    }

    private void parseRepeatable(String input) {
        switch (input) {
            case "": {
                this.repeatable = false;
                break;
            }
            case "*": {
                this.repeatable = true;
                break;
            }
            default: {
                logger.severe("unhandled 'repeatable' value: " + input);
            }
        }
        this.cardinality = this.repeatable != false ? Cardinality.Repeatable : Cardinality.Nonrepeatable;
    }

    public String getPica3() {
        return this.pica3;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isHasSheet() {
        return this.hasSheet;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "PicaTagDefinition{pica3='" + this.pica3 + "', picaplus='" + this.tag.getRaw() + "', repeatable=" + this.repeatable + ", hasSheet=" + this.hasSheet + ", description='" + this.label + "'}";
    }

    @Override
    public String getTag() {
        return this.tag.getTag();
    }

    @Override
    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public List<SubfieldDefinition> getSubfields() {
        return this.subfields;
    }

    public void setSubfields(List<SubfieldDefinition> subfields) {
        this.subfields = subfields;
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public void setDescriptionUrl(String descriptionUrl) {
        this.descriptionUrl = descriptionUrl;
    }
}

