/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaFieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaTagDefinition;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;

public class PicaSchemaReader {
    private JSONParser parser = new JSONParser();
    private Map<String, PicaFieldDefinition> map = new HashMap<String, PicaFieldDefinition>();

    private PicaSchemaReader(String fileName) {
        try {
            this.readSchema(fileName);
        }
        catch (IOException | URISyntaxException | ParseException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, PicaFieldDefinition> create(String filename) {
        PicaSchemaReader reader = new PicaSchemaReader(filename);
        return reader.map;
    }

    private void readSchema(String fileName) throws IOException, ParseException, URISyntaxException {
        Object obj = this.parser.parse((Reader)new FileReader(new File(fileName)));
        JSONObject jsonObject = (JSONObject)obj;
        JSONObject fields = (JSONObject)jsonObject.get((Object)"fields");
        for (String name : fields.keySet()) {
            JSONObject field = (JSONObject)fields.get((Object)name);
            PicaTagDefinition tag = new PicaTagDefinition((String)field.get((Object)"pica3"), name, (Boolean)field.get((Object)"repeatable"), false, (String)field.get((Object)"label"));
            tag.setDescriptionUrl((String)field.get((Object)"url"));
            this.processSubfields(field, tag);
            PicaFieldDefinition definition = new PicaFieldDefinition(tag);
            this.addTag(definition);
        }
    }

    private void processSubfields(JSONObject field, PicaTagDefinition tag) {
        Object subfieldsRaw = field.get((Object)"subfields");
        ArrayList<SubfieldDefinition> subfieldDefinitions = new ArrayList<SubfieldDefinition>();
        if (subfieldsRaw != null) {
            if (subfieldsRaw instanceof JSONObject) {
                JSONObject subfields = (JSONObject)subfieldsRaw;
                for (String key : subfields.keySet()) {
                    this.processSubfield(subfields.get((Object)key), subfieldDefinitions);
                }
            } else if (subfieldsRaw instanceof JSONArray) {
                JSONArray subfields = (JSONArray)subfieldsRaw;
                for (int i = 0; i < subfields.size(); ++i) {
                    this.processSubfield(subfields.get(i), subfieldDefinitions);
                }
            }
        }
        tag.setSubfields(subfieldDefinitions);
    }

    private void processSubfield(Object o, List<SubfieldDefinition> subfieldDefinitions) {
        SubfieldDefinition definition = this.extractSubfield(o);
        if (definition != null) {
            subfieldDefinitions.add(definition);
        }
    }

    private SubfieldDefinition extractSubfield(Object o) {
        SubfieldDefinition definition = null;
        if (o instanceof JSONObject) {
            JSONObject subfield = (JSONObject)o;
            String code = (String)subfield.get((Object)"code");
            String label = (String)subfield.get((Object)"label");
            String cardinalityCode = (Boolean)subfield.get((Object)"repeatable") != false ? Cardinality.Repeatable.getCode() : Cardinality.Nonrepeatable.getCode();
            definition = new SubfieldDefinition(code, label, cardinalityCode);
            for (String key : subfield.keySet()) {
                Object value = subfield.get((Object)key);
                if (key.equals("code") || key.equals("label") || key.equals("repeatable") || key.equals("modified") || key.equals("order") || key.equals("pica3")) continue;
                System.err.println("code: " + key);
            }
        } else {
            System.err.println(o.getClass());
        }
        return definition;
    }

    private void addTag(PicaFieldDefinition definition) {
        String tag = definition.getTag();
        if (this.map.containsKey(tag)) {
            System.err.println("Tag is already defined! " + definition.getTag() + " " + this.map.get(tag));
        }
        this.map.put(tag, definition);
    }

    public Map<String, PicaFieldDefinition> getMap() {
        return this.map;
    }
}

