/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.pica.PicaLine;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class PicaReader
implements MarcReader {
    private static final Logger logger = Logger.getLogger(PicaReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private boolean nextIsConsumed = false;
    private int lineNumber = 0;
    private List<PicaLine> lines = new ArrayList<PicaLine>();

    public PicaReader(String fileName) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error in PicaReader()", e);
        }
    }

    public boolean hasNext() {
        if (this.lineNumber == 0 || this.nextIsConsumed) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error in hasNext()", e);
            }
            ++this.lineNumber;
            this.nextIsConsumed = false;
        }
        return this.line != null;
    }

    public Record next() {
        Record marc4jRecord = null;
        boolean finished = false;
        while (this.line != null && !finished) {
            PicaLine picaLine = new PicaLine(this.line, this.lineNumber);
            if (picaLine.isSkippable() && !this.lines.isEmpty()) {
                marc4jRecord = MarcFactory.createRecordFromPica(this.lines);
                finished = true;
                this.lines = new ArrayList<PicaLine>();
            }
            if (picaLine.isValidTag()) {
                this.lines.add(picaLine);
            }
            try {
                this.line = this.bufferedReader.readLine();
                ++this.lineNumber;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "next", e);
            }
        }
        if (this.line == null && !this.lines.isEmpty()) {
            marc4jRecord = MarcFactory.createRecordFromPica(this.lines);
        }
        return marc4jRecord;
    }
}

