/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.utils.pica.PicaSubfield;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PicaLine {
    private static final Logger logger = Logger.getLogger(PicaLine.class.getCanonicalName());
    private static final Pattern LINE = Pattern.compile("^(SET:|Eingabe:|Warnung:|[0-2][0-9][0-9][A-Z@])(\\/([0-9][0-9]+))? (.*)$");
    public static final String SEPARATOR = "\u0192";
    private static final String SET = "SET";
    private static final String EINGABE = "Eingabe";
    private static final String WARNUNG = "Warnung";
    private int lineNumber = 0;
    private String tag;
    private String occurrence;
    private String content;
    private List<PicaSubfield> subfields;
    private boolean valid = false;
    private boolean skippable = false;

    public PicaLine() {
    }

    public PicaLine(String raw) {
        this.parse(raw);
    }

    public PicaLine(String raw, int lineNumber) {
        this.lineNumber = lineNumber;
        this.parse(raw);
    }

    public boolean isSET() {
        return this.tag.equals(SET);
    }

    public boolean isEingabe() {
        return this.tag.equals(EINGABE);
    }

    public boolean isWarnung() {
        return this.tag.equals(WARNUNG);
    }

    public boolean isValidTag() {
        return this.valid && !this.isSET() && !this.isEingabe() && !this.isWarnung();
    }

    public String getTag() {
        return this.tag;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public List<PicaSubfield> getSubfields() {
        return this.subfields;
    }

    public String getQualifiedTag() {
        if (this.occurrence != null) {
            return this.tag + "/" + this.occurrence;
        }
        return this.tag;
    }

    public String formatSubfields() {
        if (this.subfields == null) {
            logger.severe("null subfields: " + this.content);
            return "";
        }
        ArrayList<String> formattedSubfields = new ArrayList<String>();
        for (PicaSubfield subfield : this.subfields) {
            formattedSubfields.add(subfield.format());
        }
        return StringUtils.join(formattedSubfields, (String)", ");
    }

    public String getContent() {
        return this.content;
    }

    private void parse(String raw) {
        if (raw.equals("")) {
            this.skippable = true;
        } else {
            Matcher matcher = LINE.matcher(raw);
            if (matcher.matches()) {
                this.tag = matcher.group(1).replaceAll(":$", "");
                this.occurrence = matcher.group(3);
                this.content = matcher.group(4);
                this.parseSubfields();
                this.valid = true;
            } else {
                logger.warning(String.format("Unable to parse line: '%s'", raw));
            }
        }
    }

    private void parseSubfields() {
        String[] parts;
        this.subfields = new ArrayList<PicaSubfield>();
        for (String part : parts = this.content.split(SEPARATOR)) {
            if (!StringUtils.isNotBlank((String)part)) continue;
            this.subfields.add(new PicaSubfield(part.substring(0, 1), part.substring(1)));
        }
    }

    public String toString() {
        return "AlephseqLine{, tag='" + this.tag + "', occurrence='" + this.occurrence + "', subfields=" + this.subfields + "}";
    }

    public boolean isSkippable() {
        return this.skippable || this.isSET() || this.isEingabe() || this.isWarnung();
    }
}

