/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.alephseq;

import de.gwdg.metadataqa.marc.dao.DataField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MarclineLine {
    private static final Logger logger = Logger.getLogger(MarclineLine.class.getCanonicalName());
    private static final String LDR = "LDR";
    private static final Pattern numericTag = Pattern.compile("^\\d\\d\\d$");
    private static final Pattern controlField = Pattern.compile("^00\\d$");
    public static final String SEPARATOR = "\\$";
    private int lineNumber = 0;
    private String recordID;
    private String tag;
    private String ind1;
    private String ind2;
    private String content;
    private boolean valid = true;
    private boolean isLeader = false;

    public MarclineLine() {
    }

    public MarclineLine(String raw) {
        this.parse(raw);
    }

    public MarclineLine(String raw, int lineNumber) {
        this.lineNumber = lineNumber;
        this.parse(raw);
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public boolean isNumericTag() {
        if (this.tag == null) {
            return false;
        }
        return numericTag.matcher(this.tag).matches();
    }

    public boolean isControlField() {
        if (this.tag == null) {
            return false;
        }
        return controlField.matcher(this.tag).matches();
    }

    public boolean isValidTag() {
        return this.isValid() && (this.isLeader() || this.isNumericTag());
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String getTag() {
        return this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public String getContent() {
        if (this.content == null) {
            return this.content;
        }
        if (this.isLeader() || this.isControlField()) {
            return this.content.replace("^", " ");
        }
        return this.content.replace("$$", "$");
    }

    public String getRawContent() {
        return this.content;
    }

    private void parse(String raw) {
        if (!raw.substring(3, 4).equals(" ")) {
            this.isLeader = true;
            this.content = raw.replaceAll("^(LEADER|LDR) ", "");
        } else {
            this.tag = raw.substring(0, 3);
            if (this.tag.equals(LDR)) {
                this.isLeader = true;
                this.content = raw.replaceAll("^LDR ", "");
                this.tag = null;
            } else if (this.isControlField()) {
                this.content = raw.substring(4);
            } else {
                this.ind1 = raw.substring(4, 5);
                this.ind2 = raw.substring(5, 6);
                this.content = raw.substring(6);
            }
        }
    }

    public List<String[]> parseSubfields() {
        String[] segments;
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        for (String segment : segments = this.content.split(SEPARATOR)) {
            if (!StringUtils.isNotBlank((String)segment)) continue;
            subfields.add(new String[]{segment.substring(0, 1), segment.substring(1)});
        }
        return subfields;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "AlephseqLine{recordID='" + this.recordID + "', tag='" + this.tag + "', ind1='" + this.ind1 + "', ind2='" + this.ind2 + "', content='" + this.getContent() + "'}";
    }

    public List<String[]> getSubfields() {
        return DataField.parseSubfields(this.getContent());
    }
}

